/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client;

import com.yoti.api.client.AutoClosingKeyPairSource;
import com.yoti.api.client.InitialisationException;
import java.io.InputStream;

public final class ClassPathKeySource
extends AutoClosingKeyPairSource {
    private final InputStream stream;
    private final String asString;

    public static ClassPathKeySource fromClasspath(String location) throws InitialisationException {
        return new ClassPathKeySource(location);
    }

    private ClassPathKeySource(String location) throws InitialisationException {
        this.asString = "classpath: " + location;
        this.stream = this.getClass().getClassLoader().getResourceAsStream(location);
        if (this.stream == null) {
            throw new InitialisationException("No resource found at classpath location " + location);
        }
    }

    @Override
    protected InputStream getStream() {
        return this.stream;
    }

    public String toString() {
        return this.asString;
    }
}

