/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client;

import com.yoti.api.client.InitialisationException;
import com.yoti.api.client.KeyPairSource;
import com.yoti.api.client.YotiClient;
import com.yoti.api.client.YotiClientBuilder;
import com.yoti.api.client.YotiClientConfiguration;
import com.yoti.api.client.YotiClientFactory;
import java.io.IOException;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServiceLocatorYotiClientBuilder
extends YotiClientBuilder
implements YotiClientConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceLocatorYotiClientBuilder.class);
    private KeyPairSource keyPairSource;
    private String applicationId;

    ServiceLocatorYotiClientBuilder() {
    }

    @Override
    public YotiClientBuilder forApplication(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @Override
    public YotiClientBuilder withKeyPair(KeyPairSource keyPairSource) throws IOException {
        this.keyPairSource = keyPairSource;
        return this;
    }

    @Override
    public YotiClient build() throws InitialisationException {
        this.checkBuilderState();
        ServiceLoader<YotiClientFactory> loader = ServiceLoader.load(YotiClientFactory.class);
        Object result = null;
        for (YotiClientFactory client : loader) {
            if (!client.accepts(this.applicationId)) continue;
            result = client.getInstance(this);
        }
        if (result == null) {
            throw new IllegalStateException("No available clients found for application " + this.applicationId);
        }
        LOG.debug("Found Yoti client: {}", (Object)result.getClass().getName());
        return result;
    }

    @Override
    public KeyPairSource getKeyPairSource() {
        return this.keyPairSource;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    private void checkBuilderState() {
        if (this.keyPairSource == null) {
            throw new IllegalStateException("No key pair supplied");
        }
        if (this.applicationId == null) {
            throw new IllegalStateException("No application id supplied");
        }
    }
}

