/*
 * Decompiled with CFR 0.152.
 */
package com.zjiecode.wxpusher.client;

import com.alibaba.fastjson.JSONObject;
import com.zjiecode.wxpusher.client.bean.Result;
import com.zjiecode.wxpusher.client.bean.ResultCode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;

public final class HttpUtils {
    private static final String BASE_URL = "http://wxpusher.zjiecode.com";
    private static final String CHARSET_NAME = "UTF-8";

    private HttpUtils() {
    }

    public static Result post(Object data, String path) {
        try {
            if (data == null) {
                return new Result(ResultCode.UNKNOWN_ERROR, "\u6570\u636e\u4e3a\u7a7a");
            }
            String dataStr = JSONObject.toJSONString((Object)data);
            URL cUrl = new URL(HttpUtils.buildUrl(path));
            HttpURLConnection urlConnection = (HttpURLConnection)cUrl.openConnection();
            urlConnection.setConnectTimeout(60000);
            urlConnection.setReadTimeout(60000);
            urlConnection.setUseCaches(false);
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("Charset", CHARSET_NAME);
            urlConnection.setDoOutput(true);
            urlConnection.connect();
            OutputStream outputStream = urlConnection.getOutputStream();
            outputStream.write(dataStr.getBytes(Charset.forName(CHARSET_NAME)));
            outputStream.flush();
            return HttpUtils.dealConnect(urlConnection);
        }
        catch (MalformedURLException e) {
            return new Result(ResultCode.NETWORK_ERROR, e.getMessage());
        }
        catch (IOException e) {
            return new Result(ResultCode.NETWORK_ERROR, e.toString());
        }
        catch (Throwable e) {
            return new Result(ResultCode.UNKNOWN_ERROR, e.toString());
        }
    }

    public static Result get(String path) {
        return HttpUtils.get(null, path);
    }

    public static Result get(Map<String, Object> data, String path) {
        try {
            String url = HttpUtils.buildUrl(path);
            String query = HttpUtils.parseMap2Query(data);
            if (!query.isEmpty()) {
                url = url + "?" + query;
            }
            URL cUrl = new URL(url);
            HttpURLConnection urlConnection = (HttpURLConnection)cUrl.openConnection();
            urlConnection.setConnectTimeout(60000);
            urlConnection.setReadTimeout(60000);
            urlConnection.setUseCaches(false);
            urlConnection.setRequestMethod("GET");
            urlConnection.setRequestProperty("Charset", CHARSET_NAME);
            urlConnection.setDoOutput(true);
            urlConnection.connect();
            return HttpUtils.dealConnect(urlConnection);
        }
        catch (MalformedURLException e) {
            return new Result(ResultCode.NETWORK_ERROR, e.getMessage());
        }
        catch (IOException e) {
            return new Result(ResultCode.NETWORK_ERROR, e.toString());
        }
        catch (Throwable e) {
            return new Result(ResultCode.UNKNOWN_ERROR, e.toString());
        }
    }

    private static String parseMap2Query(Map<String, Object> data) {
        if (data == null || data.size() <= 0) {
            return "";
        }
        Set<Map.Entry<String, Object>> entries = data.entrySet();
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : entries) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    private static String buildUrl(String path) {
        String url = BASE_URL;
        if (path != null && path.length() > 0) {
            url = path.startsWith("/") ? BASE_URL + path : "http://wxpusher.zjiecode.com/" + path;
        }
        return url;
    }

    private static Result dealConnect(HttpURLConnection urlConnection) {
        try {
            int responseCode = urlConnection.getResponseCode();
            if (responseCode != 200) {
                return new Result(urlConnection.getResponseCode(), "http\u8bf7\u6c42\u9519\u8bef:" + responseCode);
            }
            InputStream inputStream = urlConnection.getInputStream();
            String res = HttpUtils.inputStream2String(inputStream);
            if (res == null || res.isEmpty()) {
                return new Result(ResultCode.INTERNAL_SERVER_ERROR, "\u670d\u52a1\u5668\u8fd4\u56de\u5f02\u5e38");
            }
            Result result = (Result)JSONObject.parseObject((String)res, Result.class);
            if (result == null) {
                return new Result(ResultCode.DATA_ERROR, "\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u89e3\u6790\u5f02\u5e38");
            }
            return result;
        }
        catch (MalformedURLException e) {
            return new Result(ResultCode.NETWORK_ERROR, e.getMessage());
        }
        catch (IOException e) {
            return new Result(ResultCode.NETWORK_ERROR, e.getMessage());
        }
        catch (Throwable e) {
            return new Result(ResultCode.UNKNOWN_ERROR, e.getMessage());
        }
    }

    private static String inputStream2String(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int len = 0;
        byte[] bytes = new byte[4096];
        try {
            while ((len = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, len);
            }
            return new String(outputStream.toByteArray(), CHARSET_NAME);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

