/*
 * Decompiled with CFR 0.152.
 */
package com.zjiecode.wxpusher.client;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.zjiecode.wxpusher.client.HttpUtils;
import com.zjiecode.wxpusher.client.bean.CreateQrcodeReq;
import com.zjiecode.wxpusher.client.bean.CreateQrcodeResp;
import com.zjiecode.wxpusher.client.bean.Message;
import com.zjiecode.wxpusher.client.bean.MessageResult;
import com.zjiecode.wxpusher.client.bean.Page;
import com.zjiecode.wxpusher.client.bean.Result;
import com.zjiecode.wxpusher.client.bean.ResultCode;
import com.zjiecode.wxpusher.client.bean.WxUser;
import java.util.HashMap;
import java.util.List;

public final class WxPusher {
    private WxPusher() {
    }

    public static Result<List<MessageResult>> send(Message message) {
        Result result = WxPusher.verify(message);
        if (result != null) {
            return result;
        }
        Result sendResult = HttpUtils.post(message, "/api/send/message");
        if (sendResult.isSuccess()) {
            Object data = sendResult.getData();
            String s = JSONObject.toJSONString(data);
            List messageResults = (List)JSONObject.parseObject((String)s, (TypeReference)new TypeReference<List<MessageResult>>(){}, (Feature[])new Feature[0]);
            sendResult.setData(messageResults);
        }
        return sendResult;
    }

    public static Result queryMessageStatus(Long messageId) {
        if (messageId == null || messageId <= 0L) {
            return new Result(ResultCode.BIZ_FAIL, "messageId\u4e3a\u7a7a");
        }
        return HttpUtils.get(String.format("/api/send/query/%s", messageId));
    }

    public static Result<CreateQrcodeResp> createAppTempQrcode(CreateQrcodeReq createQrcodeReq) {
        Result result = HttpUtils.post(createQrcodeReq, "/api/fun/create/qrcode");
        if (result.getData() != null) {
            String jsonString = JSONObject.toJSONString(result.getData());
            CreateQrcodeResp createQrcodeResp = (CreateQrcodeResp)JSONObject.parseObject((String)jsonString, CreateQrcodeResp.class);
            result.setData(createQrcodeResp);
        }
        return result;
    }

    public static Result<Page<WxUser>> queryWxUser(String appToken, Integer page, Integer pageSize) {
        return WxPusher.queryWxUser(appToken, page, pageSize, null);
    }

    public static Result<Page<WxUser>> queryWxUser(String appToken, String uid) {
        return WxPusher.queryWxUser(appToken, 1, 1, uid);
    }

    public static Result<Page<WxUser>> queryWxUser(String appToken, Integer page, Integer pageSize, String uid) {
        Result result;
        if (appToken == null || appToken.isEmpty()) {
            return new Result<Page<WxUser>>(ResultCode.BIZ_FAIL, "appToken\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (page == null || page <= 0) {
            return new Result<Page<WxUser>>(ResultCode.BIZ_FAIL, "page\u4e0d\u5408\u6cd5");
        }
        if (page == null || page <= 0) {
            return new Result<Page<WxUser>>(ResultCode.BIZ_FAIL, "pageSize\u4e0d\u5408\u6cd5");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appToken", appToken);
        params.put("page", page);
        params.put("pageSize", pageSize);
        if (uid != null && !uid.isEmpty()) {
            params.put("uid", uid);
        }
        if ((result = HttpUtils.get(params, "/api/fun/wxuser")).getData() != null) {
            String jsonString = JSONObject.toJSONString(result.getData());
            Page pageData = (Page)JSONObject.parseObject((String)jsonString, (TypeReference)new TypeReference<Page<WxUser>>(){}, (Feature[])new Feature[0]);
            result.setData(pageData);
        }
        return result;
    }

    private static Result verify(Message message) {
        if (message == null) {
            return new Result(ResultCode.BIZ_FAIL, "\u6d88\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (message.getAppToken() == null || message.getAppToken().length() <= 0) {
            return new Result(ResultCode.BIZ_FAIL, "appToken\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (message.getContent() == null || message.getContent().length() <= 0) {
            return new Result(ResultCode.BIZ_FAIL, "content\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return null;
    }
}

