/*
 * Decompiled with CFR 0.152.
 */
package com.zman.stream.socket.pull;

import com.zman.pull.stream.IDuplex;
import com.zman.stream.socket.pull.EasyBuffer;
import com.zman.stream.socket.pull.SocketDuplex;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.function.Consumer;

public class SelectionKeyProcessor {
    private static final int OP_NOT_CONNECT = -9;
    private static final int OP_NOT_READ = -2;
    private static final int OP_NOT_WRITE = -5;

    SocketDuplex processConnect(SelectionKey key, Selector selector, Consumer<IDuplex> onConnectedCallback) throws IOException {
        key.interestOps(0xFFFFFFF7 & key.interestOps());
        SocketChannel channel = (SocketChannel)key.channel();
        if (channel.isConnectionPending()) {
            channel.finishConnect();
        }
        SocketDuplex duplex = new SocketDuplex(selector, channel);
        onConnectedCallback.accept((IDuplex)duplex);
        return duplex;
    }

    void processReadable(SelectionKey key, SocketDuplex duplex, SocketChannel socketChannel) throws IOException {
        key.interestOps(0xFFFFFFFE & key.interestOps());
        EasyBuffer easyBuffer = duplex.getSourceBuffer();
        ByteBuffer byteBuffer = easyBuffer.getWritableByteBuffer();
        int num = socketChannel.read(byteBuffer);
        if (num == -1) {
            duplex.source().close();
        }
        if (!duplex.source().push((Object)easyBuffer)) {
            throw new RuntimeException("invoking duplex.push failed, this is unreachable");
        }
    }

    void processWritable(SelectionKey key, SocketDuplex duplex, SocketChannel socketChannel) throws IOException {
        EasyBuffer easyBuffer = duplex.getSinkBuffer();
        ByteBuffer byteBuffer = easyBuffer.getReadableByteBuffer();
        int remaining = byteBuffer.remaining();
        if (remaining > 0) {
            int writeCount = socketChannel.write(byteBuffer);
            if (writeCount == remaining) {
                key.interestOps(0xFFFFFFFB & key.interestOps());
                duplex.sink().read(duplex.sink().source());
            }
        } else {
            key.interestOps(0xFFFFFFFB & key.interestOps());
            duplex.sink().read(duplex.sink().source());
        }
    }
}

