/*
 * Decompiled with CFR 0.152.
 */
package com.zman.stream.socket.pull;

import com.zman.net.pull.AbstractClient;
import com.zman.pull.stream.IDuplex;
import com.zman.stream.socket.pull.SelectionKeyProcessor;
import com.zman.stream.socket.pull.SocketDuplex;
import com.zman.thread.eventloop.EventLoop;
import com.zman.thread.eventloop.impl.TaskType;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.Callable;

public class SocketClient
extends AbstractClient<IDuplex> {
    private EventLoop eventLoop;
    private Selector selector;
    private SocketChannel socketChannel;
    private SocketDuplex duplex;
    private SelectionKeyProcessor keyProcessor;
    private Callable<?> ioAction = () -> {
        try {
            if (!this.socketChannel.isOpen()) {
                this.onDisconnectedCallback.run();
                return null;
            }
            if (this.selector.select(10L) > 0) {
                this.processSelectedKeys();
            }
        }
        catch (Throwable t) {
            this.onThrowableCallback.accept(t);
            try {
                this.socketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.eventLoop.submit(TaskType.IO.name(), this.ioAction);
        return null;
    };

    public SocketClient(EventLoop eventLoop) {
        this(eventLoop, new SelectionKeyProcessor());
    }

    public SocketClient(EventLoop eventLoop, SelectionKeyProcessor selectionKeyProcessor) {
        this.eventLoop = eventLoop;
        this.keyProcessor = selectionKeyProcessor;
    }

    public void connect(String ip, int port) {
        try {
            this.selector = Selector.open();
            this.socketChannel = SocketChannel.open();
            this.socketChannel.configureBlocking(false);
            this.socketChannel.register(this.selector, 8);
            this.socketChannel.connect(new InetSocketAddress(ip, port));
        }
        catch (Throwable t) {
            this.onThrowableCallback.accept(t);
            return;
        }
        this.eventLoop.submit(TaskType.IO.name(), this.ioAction);
    }

    public void disconnect() {
        try {
            this.socketChannel.close();
        }
        catch (IOException e) {
            this.onThrowableCallback.accept(e);
        }
    }

    private void processSelectedKeys() throws IOException {
        Iterator<SelectionKey> keyIterator = this.selector.selectedKeys().iterator();
        while (keyIterator.hasNext()) {
            SelectionKey key = keyIterator.next();
            keyIterator.remove();
            if (key.isConnectable()) {
                this.duplex = this.keyProcessor.processConnect(key, this.selector, this.onConnectedCallback);
                continue;
            }
            if (key.isReadable()) {
                this.keyProcessor.processReadable(key, this.duplex, this.socketChannel);
                continue;
            }
            if (!key.isWritable()) continue;
            this.keyProcessor.processWritable(key, this.duplex, this.socketChannel);
        }
    }
}

