/*
 * Decompiled with CFR 0.152.
 */
package com.zman.stream.socket.pull;

import com.zman.pull.stream.impl.DefaultDuplex;
import com.zman.stream.socket.pull.EasyBuffer;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class SocketDuplex
extends DefaultDuplex<EasyBuffer> {
    private Selector selector;
    private SocketChannel socketChannel;
    private EasyBuffer sinkBuffer;
    private EasyBuffer sourceBuffer = new EasyBuffer();

    public SocketDuplex(Selector selector, SocketChannel socketChannel) {
        this.selector = selector;
        this.socketChannel = socketChannel;
        this.sink().onClosed(throwable -> this.close(null)).onNext(this::onData).onWait(() -> {
            try {
                this.interestOps(socketChannel, selector, 1);
            }
            catch (ClosedChannelException e) {
                this.close(e);
            }
        });
    }

    public void close(Throwable throwable) {
        try {
            this.socketChannel.close();
            this.source().close(throwable);
            this.sink().close(throwable);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Boolean onData(EasyBuffer data) {
        this.sinkBuffer = data;
        try {
            this.interestOps(this.socketChannel, this.selector, 4);
        }
        catch (ClosedChannelException e) {
            this.close(e);
        }
        return true;
    }

    private void interestOps(SocketChannel socketChannel, Selector selector, int ops) throws ClosedChannelException {
        SelectionKey key = selector.keys().stream().findFirst().orElse(null);
        if (key == null) {
            throw new RuntimeException("selector doesn't have a selectionKey, unreachable");
        }
        socketChannel.register(selector, key.interestOps() | ops);
    }

    public EasyBuffer getSinkBuffer() {
        return this.sinkBuffer;
    }

    public EasyBuffer getSourceBuffer() {
        return this.sourceBuffer;
    }
}

