/*
 * Decompiled with CFR 0.152.
 */
package com.zman.stream.socket.pull.codec;

import com.zman.pull.stream.ISink;
import com.zman.pull.stream.bean.ReadResult;
import com.zman.pull.stream.bean.ReadResultEnum;
import com.zman.pull.stream.impl.DefaultThrough;
import com.zman.stream.socket.pull.EasyBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class SocketDecoder
extends DefaultThrough<EasyBuffer, byte[]> {
    private Status status = Status.StartReadingHead;
    private ByteBuffer headBuffer = ByteBuffer.allocate(4);
    private ByteBuffer bodyBuffer;
    private int contentLength = -1;
    private BlockingQueue<byte[]> updateBuffer = new LinkedBlockingQueue<byte[]>();

    public ReadResult<byte[]> get(boolean end, Throwable throwable, ISink sink) {
        if (this.updateBuffer.size() > 0) {
            return new ReadResult(this.updateBuffer.poll());
        }
        ReadResult readResult = this.source.get(end, throwable, sink);
        if (ReadResultEnum.Available.equals((Object)readResult.status)) {
            EasyBuffer buffer = (EasyBuffer)readResult.data;
            ByteBuffer buf = buffer.getReadableByteBuffer();
            while (buf.hasRemaining()) {
                switch (this.status) {
                    case StartReadingHead: {
                        if (buf.remaining() >= 4) {
                            this.contentLength = buf.getInt();
                            this.status = Status.StartReadingBody;
                            break;
                        }
                        this.headBuffer.put(buf);
                        this.status = Status.ContinueReadingHead;
                        break;
                    }
                    case ContinueReadingHead: {
                        byte[] tmp;
                        int remainHeadLength = 4 - this.headBuffer.position();
                        if (buf.remaining() >= remainHeadLength) {
                            tmp = new byte[remainHeadLength];
                            buf.get(tmp);
                            this.headBuffer.put(tmp).flip();
                            this.contentLength = this.headBuffer.getInt();
                            this.status = Status.StartReadingBody;
                            break;
                        }
                        this.headBuffer.put(buf);
                        break;
                    }
                    case StartReadingBody: {
                        byte[] tmp;
                        this.bodyBuffer = ByteBuffer.allocate(this.contentLength);
                        if (buf.remaining() >= this.contentLength) {
                            tmp = new byte[this.contentLength];
                            buf.get(tmp);
                            this.updateBuffer.offer(tmp);
                            this.reset();
                            break;
                        }
                        tmp = new byte[buf.remaining()];
                        buf.get(tmp);
                        this.bodyBuffer.put(tmp);
                        this.status = Status.ContinueReadingBody;
                        break;
                    }
                    case ContinueReadingBody: {
                        byte[] tmp;
                        if (buf.remaining() >= this.contentLength - this.bodyBuffer.position()) {
                            tmp = new byte[this.contentLength - this.bodyBuffer.position()];
                            buf.get(tmp);
                            this.bodyBuffer.put(tmp).flip();
                            tmp = new byte[this.contentLength];
                            this.bodyBuffer.get(tmp);
                            this.updateBuffer.offer(tmp);
                            this.reset();
                            break;
                        }
                        tmp = new byte[buf.remaining()];
                        buf.get(tmp);
                        this.bodyBuffer.put(tmp);
                    }
                }
            }
            if (this.updateBuffer.size() > 0) {
                readResult = new ReadResult(this.updateBuffer.poll());
            }
        }
        return readResult;
    }

    private void reset() {
        this.headBuffer.clear();
        this.bodyBuffer.clear();
        this.status = Status.StartReadingHead;
    }

    static enum Status {
        StartReadingHead,
        ContinueReadingHead,
        StartReadingBody,
        ContinueReadingBody;

    }
}

