/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.check.Nullable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public final class DefaultSet<T>
extends HashSet<T> {
    private static final long serialVersionUID = 2969592903102269986L;
    @Nullable
    private T defaultEntry = null;

    public DefaultSet() {
    }

    public DefaultSet(Collection<? extends T> elements) {
        super(elements);
        Iterator<T> iterator = elements.iterator();
        if (iterator.hasNext()) {
            this.addDefault(iterator.next());
        }
    }

    @Override
    public boolean add(@Nullable T entry) {
        if (this.defaultEntry == null) {
            this.defaultEntry = entry;
        }
        return super.add(entry);
    }

    @Override
    public void clear() {
        this.defaultEntry = null;
        super.clear();
    }

    public void addDefault(@Nullable T entry) {
        this.add(entry);
        this.defaultEntry = entry;
    }

    @Nullable
    public T getDefault() {
        return this.defaultEntry;
    }
}

