/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asp.client;

import de.jcup.asp.api.Command;
import de.jcup.asp.api.Commands;
import de.jcup.asp.api.MapRequestParameterKey;
import de.jcup.asp.api.Request;
import de.jcup.asp.api.RequestParameterKey;
import de.jcup.asp.api.Response;
import de.jcup.asp.api.StringRequestParameterKey;
import de.jcup.asp.api.ValueProvider;
import de.jcup.asp.client.AspClientAction;
import de.jcup.asp.client.AspClientException;
import de.jcup.asp.client.AspClientProgressMonitor;
import de.jcup.asp.client.AspClientProgressMonitorSurveillance;
import de.jcup.asp.client.NoConnectionAspClientException;
import de.jcup.asp.client.NullAspClientProgressMonitor;
import de.jcup.asp.client.OutputHandlerCommunicationListener;
import de.jcup.asp.client.Version;
import de.jcup.asp.core.CryptoAccess;
import de.jcup.asp.core.LogHandler;
import de.jcup.asp.core.OutputHandler;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspClient {
    private static final Logger LOG = LoggerFactory.getLogger(AspClient.class);
    private int portNumber = 4444;
    private CryptoAccess cryptoAccess;
    private OutputHandler outputHandler;
    private LogHandler logHandler;
    private boolean showCommunication;
    private AspClientProgressMonitorSurveillance progressMonitorSurveillance;
    private OutputHandlerCommunicationListener outputHandlerCommunicationListener;

    public AspClient(String base64EncodedKey) {
        Objects.requireNonNull(base64EncodedKey, "key may not be null");
        if (base64EncodedKey.trim().isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.cryptoAccess = new CryptoAccess(base64EncodedKey);
        this.outputHandlerCommunicationListener = new OutputHandlerCommunicationListener();
        this.progressMonitorSurveillance = AspClientProgressMonitorSurveillance.INSTANCE;
    }

    public void setShowCommunication(boolean show) {
        this.showCommunication = show;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public void setOutputHandler(OutputHandler outputHandler) {
        this.outputHandler = outputHandler;
        this.outputHandlerCommunicationListener.setOutputHandler(outputHandler);
    }

    public void setLogHandler(LogHandler logHandler) {
        this.logHandler = logHandler;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public Response convertFile(Path adocfile, Map<String, Object> options, AspClientProgressMonitor monitor) throws AspClientException {
        Request request = this.createRequest();
        request.set((RequestParameterKey)StringRequestParameterKey.COMMAND, (ValueProvider)Commands.CONVERT_FILE);
        request.set((RequestParameterKey)StringRequestParameterKey.SOURCE_FILEPATH, adocfile.toAbsolutePath().toString());
        request.set((RequestParameterKey)MapRequestParameterKey.OPTIONS, options);
        return this.callServer(request, monitor);
    }

    @Deprecated
    public Response resolveAttributes(File baseDir, AspClientProgressMonitor monitor) throws AspClientException {
        Request request = this.createRequest();
        request.set((RequestParameterKey)StringRequestParameterKey.COMMAND, (ValueProvider)Commands.RESOLVE_ATTRIBUTES_FROM_DIRECTORY);
        request.set((RequestParameterKey)StringRequestParameterKey.BASE_DIR, baseDir.getAbsolutePath());
        return this.callServer(request, monitor);
    }

    public boolean isServerAlive(AspClientProgressMonitor monitor) {
        Request request = this.createRequest();
        request.set((RequestParameterKey)StringRequestParameterKey.COMMAND, (ValueProvider)Commands.IS_ALIVE);
        try {
            this.callServer(request, monitor);
            return true;
        }
        catch (NoConnectionAspClientException e) {
            return false;
        }
        catch (AspClientException e) {
            String message = "Connection possible, but:" + e.getMessage();
            if (this.outputHandler != null) {
                this.outputHandler.output(message);
            }
            if (this.logHandler != null) {
                this.logHandler.error(message, (Throwable)e);
            } else {
                LOG.error(message, (Throwable)e);
            }
            return false;
        }
    }

    private Request createRequest() {
        Request request = new Request();
        request.set((RequestParameterKey)StringRequestParameterKey.VERSION, Version.getVersion());
        return request;
    }

    private Response callServer(Request r, AspClientProgressMonitor monitor) throws AspClientException {
        Command command;
        if (monitor == null) {
            monitor = NullAspClientProgressMonitor.NULL_PROGRESS;
        }
        if ((command = r.getCommand()) == null) {
            throw new AspClientException("No command set");
        }
        if (monitor.isCanceled()) {
            return AspClientAction.createCancelResponse(r);
        }
        OutputHandlerCommunicationListener listener = null;
        if (this.showCommunication) {
            listener = this.outputHandlerCommunicationListener;
        }
        AspClientAction cr = new AspClientAction(this.cryptoAccess, this.portNumber, listener, r, monitor);
        this.progressMonitorSurveillance.inspect(cr, 0);
        cr.run();
        if (cr.getException() != null) {
            throw cr.getException();
        }
        if (cr.getResponse() == null) {
            throw new AspClientException("Unhandled request");
        }
        return cr.getResponse();
    }
}

