/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.features.observationtable.writer;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import de.learnlib.algorithms.features.observationtable.ObservationTable;
import de.learnlib.algorithms.features.observationtable.writer.ObservationTableWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import net.automatalib.words.Word;

public abstract class AbstractObservationTableWriter<I, O>
implements ObservationTableWriter<I, O> {
    private Function<? super Word<? extends I>, ? extends String> wordToString;
    private Function<? super O, ? extends String> outputToString;

    public AbstractObservationTableWriter() {
        this(Functions.toStringFunction(), Functions.toStringFunction());
    }

    public AbstractObservationTableWriter(Function<? super Word<? extends I>, ? extends String> wordToString, Function<? super O, ? extends String> outputToString) {
        this.wordToString = AbstractObservationTableWriter.safeToStringFunction(wordToString);
        this.outputToString = AbstractObservationTableWriter.safeToStringFunction(outputToString);
    }

    public void setWordToString(Function<? super Word<? extends I>, ? extends String> wordToString) {
        this.wordToString = AbstractObservationTableWriter.safeToStringFunction(wordToString);
    }

    public void setOutputToString(Function<? super O, ? extends String> outputToString) {
        this.outputToString = AbstractObservationTableWriter.safeToStringFunction(outputToString);
    }

    protected String wordToString(Word<? extends I> word) {
        return (String)this.wordToString.apply(word);
    }

    protected String outputToString(O output) {
        return (String)this.outputToString.apply(output);
    }

    protected static <T> Function<? super T, ? extends String> safeToStringFunction(Function<? super T, ? extends String> toStringFunction) {
        if (toStringFunction != null) {
            return toStringFunction;
        }
        return Functions.toStringFunction();
    }

    @Override
    public void write(ObservationTable<? extends I, ? extends O> table, PrintStream out) {
        try {
            this.write(table, (Appendable)out);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)"Writing to PrintStream must not throw");
        }
    }

    @Override
    public void write(ObservationTable<? extends I, ? extends O> table, StringBuilder out) {
        try {
            this.write(table, (Appendable)out);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)"Writing to StringBuilder must not throw");
        }
    }

    @Override
    public void write(ObservationTable<? extends I, ? extends O> table, File file) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            this.write(table, bw);
        }
    }
}

