/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.features.observationtable.writer;

import com.google.common.base.Function;
import de.learnlib.algorithms.features.observationtable.ObservationTable;
import de.learnlib.algorithms.features.observationtable.writer.AbstractObservationTableWriter;
import java.io.IOException;
import java.util.List;
import net.automatalib.words.Word;

public class ObservationTableASCIIWriter<I, O>
extends AbstractObservationTableWriter<I, O> {
    private boolean rowSeparators;

    public ObservationTableASCIIWriter(Function<? super Word<? extends I>, ? extends String> wordToString, Function<? super O, ? extends String> outputToString, boolean rowSeparators) {
        super(wordToString, outputToString);
        this.rowSeparators = rowSeparators;
    }

    public ObservationTableASCIIWriter(boolean rowSeparators) {
        this.rowSeparators = rowSeparators;
    }

    public ObservationTableASCIIWriter() {
        this(true);
    }

    public void setRowSeparators(boolean rowSeparators) {
        this.rowSeparators = rowSeparators;
    }

    @Override
    public void write(ObservationTable<? extends I, ? extends O> table, Appendable out) throws IOException {
        List<Word<I>> suffixes = table.getSuffixes();
        int numSuffixes = suffixes.size();
        int[] colWidth = new int[numSuffixes + 1];
        int i = 1;
        for (Word<I> word : suffixes) {
            colWidth[i++] = this.wordToString(word).length();
        }
        for (ObservationTable.Row row : table.getAllRows()) {
            int n = this.wordToString(row.getLabel()).length();
            if (n > colWidth[0]) {
                colWidth[0] = n;
            }
            i = 1;
            for (Object value : row) {
                n = this.outputToString(value).length();
                if (n > colWidth[i]) {
                    colWidth[i] = n;
                }
                ++i;
            }
        }
        ObservationTableASCIIWriter.appendSeparatorRow(out, '=', colWidth);
        String[] content = new String[numSuffixes + 1];
        content[0] = "";
        i = 1;
        for (Word<I> word : suffixes) {
            content[i++] = this.wordToString(word);
        }
        ObservationTableASCIIWriter.appendContentRow(out, content, colWidth);
        ObservationTableASCIIWriter.appendSeparatorRow(out, '=', colWidth);
        boolean bl = true;
        for (ObservationTable.Row<I, O> spRow : table.getShortPrefixRows()) {
            boolean bl2;
            if (bl2) {
                bl2 = false;
            } else if (this.rowSeparators) {
                ObservationTableASCIIWriter.appendSeparatorRow(out, '-', colWidth);
            }
            content[0] = this.wordToString(spRow.getLabel());
            i = 1;
            for (Object value : spRow) {
                content[i++] = this.outputToString(value);
            }
            ObservationTableASCIIWriter.appendContentRow(out, content, colWidth);
        }
        ObservationTableASCIIWriter.appendSeparatorRow(out, '=', colWidth);
        boolean bl3 = true;
        for (ObservationTable.Row<I, O> lpRow : table.getLongPrefixRows()) {
            boolean bl4;
            if (bl4) {
                bl4 = false;
            } else if (this.rowSeparators) {
                ObservationTableASCIIWriter.appendSeparatorRow(out, '-', colWidth);
            }
            content[0] = this.wordToString(lpRow.getLabel());
            i = 1;
            for (Object value : lpRow.getContents()) {
                content[i++] = this.outputToString(value);
            }
            ObservationTableASCIIWriter.appendContentRow(out, content, colWidth);
        }
        ObservationTableASCIIWriter.appendSeparatorRow(out, '=', colWidth);
    }

    private static void appendSeparatorRow(Appendable a, char sepChar, int[] colWidth) throws IOException {
        a.append('+').append(sepChar);
        ObservationTableASCIIWriter.appendRepeated(a, sepChar, colWidth[0]);
        for (int i = 1; i < colWidth.length; ++i) {
            a.append(sepChar).append('+').append(sepChar);
            ObservationTableASCIIWriter.appendRepeated(a, sepChar, colWidth[i]);
        }
        a.append(sepChar).append("+\n");
    }

    private static void appendContentRow(Appendable a, String[] content, int[] colWidth) throws IOException {
        a.append("| ");
        ObservationTableASCIIWriter.appendRightPadded(a, content[0], colWidth[0]);
        for (int i = 1; i < content.length; ++i) {
            a.append(" | ");
            ObservationTableASCIIWriter.appendRightPadded(a, content[i], colWidth[i]);
        }
        a.append(" |\n");
    }

    private static void appendRightPadded(Appendable a, String string, int width) throws IOException {
        a.append(string);
        ObservationTableASCIIWriter.appendRepeated(a, ' ', width - string.length());
    }

    private static void appendRepeated(Appendable a, char c, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            a.append(c);
        }
    }
}

