/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.InvalidTransformException;
import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class FilterReturn
extends Transform {
    private final MethodHandle function;

    public FilterReturn(MethodHandle function) {
        this.function = function;
    }

    @Override
    public MethodHandle up(MethodHandle target) {
        return MethodHandles.filterReturnValue(target, this.function);
    }

    @Override
    public MethodType down(MethodType type) {
        int count = this.function.type().parameterCount();
        switch (count) {
            case 0: {
                return type.changeReturnType(Void.TYPE);
            }
            case 1: {
                return type.changeReturnType((Class<?>)this.function.type().parameterType(0));
            }
        }
        throw new InvalidTransformException("return filter " + this.function + " does not accept zero or one argument");
    }

    @Override
    public String toString() {
        return "filter return with " + this.function;
    }
}

