/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.javascript;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.javascript.JavaScriptExecutor;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.dynjs.Config;
import org.dynjs.exception.DynJSException;
import org.dynjs.runtime.DynJS;
import org.dynjs.runtime.Runner;
import org.dynjs.runtime.builtins.types.string.DynString;
import org.dynjs.runtime.modules.JavaFunction;

public class JavaScriptExecutorDynJs
implements JavaScriptExecutor {
    private String source;
    private final DynJS runtime;
    private final Runner runner;
    private boolean prepared = false;

    public JavaScriptExecutorDynJs() {
        Config config = new Config();
        this.runtime = new DynJS(config);
        this.runner = this.runtime.newRunner();
        this.addScriptFile(this.getClass().getResource("/npm_modules.js"));
    }

    public JavaScriptExecutorDynJs(ClassLoader classLoader) {
        Config config = new Config(classLoader);
        this.runtime = new DynJS(config);
        this.runner = this.runtime.newRunner();
    }

    @Override
    public void addGlobalFunction(String name, Object object) {
        this.addGlobalFunction(name, object, name);
    }

    @Override
    public void addGlobalFunction(String name, Object object, String methodName) {
        Method method = null;
        for (Method m : object.getClass().getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            method = m;
        }
        if (method == null) {
            throw new SmallerException("Method '" + methodName + "' not found");
        }
        try {
            this.runtime.getExecutionContext().getGlobalObject().put(name, (Object)new JavaFunction(this.runtime.getExecutionContext().getGlobalObject(), object, method));
        }
        catch (IllegalAccessException e) {
            throw new SmallerException("Failed to add method '" + methodName + "'", (Throwable)e);
        }
    }

    @Override
    public void addScriptSource(String source, String name) {
        if (!this.prepared) {
            this.runner.withSource(source).evaluate();
        }
    }

    @Override
    public void addScriptFile(String file) {
        if (!this.prepared) {
            this.runner.withFileName(file).evaluate();
        }
    }

    @Override
    public void addScriptFile(URL url) {
        if (!this.prepared) {
            try {
                this.runner.withSource(IOUtils.toString((URL)url)).evaluate();
            }
            catch (IOException e) {
                throw new SmallerException("Failed to read url", (Throwable)e);
            }
        }
    }

    @Override
    public void addCallScript(String source) {
        this.source = source;
    }

    @Override
    public void run(Reader input, Writer output) throws IOException {
        this.prepared = true;
        try {
            String data = new ObjectMapper().writeValueAsString((Object)IOUtils.toString((Reader)input));
            Object o = this.runner.withSource(String.format(this.source, data)).execute();
            if (o instanceof DynString) {
                o = ((DynString)o).getPrimitiveValue();
            }
            IOUtils.write((String)o.toString(), (Writer)output);
        }
        catch (DynJSException e) {
            throw new SmallerException("Failed to execute javascript", (Throwable)e);
        }
    }

    @Override
    public void dispose() {
    }
}

