/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import org.dynjs.Config;
import org.dynjs.cli.Arguments;
import org.dynjs.cli.Repl;
import org.dynjs.runtime.DynJS;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public class Main {
    private Arguments dynJsArguments = new Arguments();
    private CmdLineParser parser = new CmdLineParser(this.dynJsArguments);
    private String[] arguments;
    private PrintStream stream;
    private Config config;
    private DynJS runtime;

    public Main(PrintStream stream, String[] args) {
        this.parser.setUsageWidth(80);
        this.arguments = args;
        this.stream = stream;
    }

    public static void main(String[] args) throws IOException {
        new Main(System.out, args).run();
    }

    void run() throws IOException {
        try {
            this.parser.parseArgument(this.arguments);
            if (this.dynJsArguments.isHelp() || this.dynJsArguments.isEmpty()) {
                this.showUsage();
            } else if (this.dynJsArguments.getFilename() != null) {
                this.executeFile(this.dynJsArguments.getFilename());
            } else if (this.dynJsArguments.isConsole()) {
                this.startRepl();
            } else if (this.dynJsArguments.isVersion()) {
                this.showVersion();
            }
        }
        catch (CmdLineException e) {
            this.stream.println(e.getMessage());
            this.stream.println();
            this.showUsage();
        }
    }

    private void executeFile(String filename) throws IOException {
        try {
            this.initializeRuntime();
            this.runtime.newRunner().withSource(new File(filename)).execute();
        }
        catch (FileNotFoundException e) {
            this.stream.println("File " + filename + " not found");
        }
    }

    private void showVersion() {
        this.stream.println("dynjs " + DynJS.VERSION);
    }

    private void startRepl() {
        this.initializeRuntime();
        Repl repl = new Repl(this.runtime, System.in, this.stream);
        repl.run();
    }

    private void showUsage() {
        StringBuilder usageText = new StringBuilder("Usage: dynjs [--console |--debug | --help | --version |FILE]\n");
        usageText.append("Starts the dynjs console or executes FILENAME depending the parameters\n");
        this.stream.println(usageText.toString());
        this.parser.printUsage(this.stream);
    }

    private void initializeRuntime() {
        this.config = this.dynJsArguments.getConfig();
        this.config.setOutputStream(this.stream);
        this.runtime = new DynJS(this.config);
    }
}

