/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.compiler.bytecode.partial;

import java.util.ArrayList;
import java.util.List;
import me.qmx.jitescript.JiteClass;
import me.qmx.jitescript.util.CodegenUtils;
import org.dynjs.Config;
import org.dynjs.codegen.CodeGeneratingVisitorFactory;
import org.dynjs.compiler.bytecode.partial.AbstractPartialCompiler;
import org.dynjs.compiler.bytecode.partial.MultipleClassCaller;
import org.dynjs.compiler.bytecode.partial.MultipleClassInitializer;
import org.dynjs.compiler.bytecode.partial.PartialCompiler;
import org.dynjs.compiler.bytecode.partial.SingleClassCompiler;
import org.dynjs.parser.ast.BlockStatement;
import org.dynjs.runtime.BasicBlock;
import org.dynjs.runtime.Completion;
import org.dynjs.runtime.DynamicClassLoader;
import org.dynjs.runtime.ExecutionContext;

public class MultipleClassCompiler
extends AbstractPartialCompiler {
    private List<PartialCompiler> plans;

    public MultipleClassCompiler(Config config, DynamicClassLoader classLoader, CodeGeneratingVisitorFactory factory, List<BlockStatement> chunks, int chunkSize) {
        super(config, classLoader, factory);
        ArrayList<PartialCompiler> plans = new ArrayList<PartialCompiler>();
        int classStart = 0;
        while (classStart < chunks.size()) {
            int classEnd = classStart + chunkSize;
            if (classEnd > chunks.size()) {
                classEnd = chunks.size();
            }
            List<BlockStatement> classChunks = chunks.subList(classStart, classEnd);
            SingleClassCompiler classPlan = new SingleClassCompiler(this, classChunks);
            plans.add(classPlan);
            classStart = classEnd;
        }
        this.plans = this.treeify(plans, chunkSize);
    }

    private MultipleClassCompiler(MultipleClassCompiler parent, List<PartialCompiler> plans) {
        super(parent);
        this.plans = plans;
    }

    private List<PartialCompiler> treeify(List<PartialCompiler> plans, int chunkSize) {
        while (plans.size() > chunkSize) {
            ArrayList<PartialCompiler> newPlans = new ArrayList<PartialCompiler>();
            int treeStart = 0;
            while (treeStart < plans.size()) {
                int treeEnd = treeStart + chunkSize;
                if (treeEnd > plans.size()) {
                    treeEnd = plans.size();
                }
                List<PartialCompiler> treePlans = plans.subList(treeStart, treeEnd);
                MultipleClassCompiler treePlan = new MultipleClassCompiler(this, treePlans);
                newPlans.add(treePlan);
                treeStart = treeEnd;
            }
            plans = newPlans;
        }
        return plans;
    }

    @Override
    public void define(JiteClass cls, ExecutionContext context, boolean strict) {
        int numChunks = this.plans.size();
        for (int i = 0; i < numChunks; ++i) {
            JiteClass chunkClass = new JiteClass(cls.getClassName() + "$" + i, new String[]{CodegenUtils.p(BasicBlock.class)});
            chunkClass.defineDefaultConstructor();
            this.plans.get(i).define(chunkClass, context, strict);
            this.defineClass(chunkClass);
            cls.defineField("chunk" + i, 2, CodegenUtils.ci(BasicBlock.class), null);
        }
        cls.defineMethod("call", 1, CodegenUtils.sig(Completion.class, ExecutionContext.class), new MultipleClassCaller(cls.getClassName(), numChunks));
        cls.defineMethod("initializeCode", 2, CodegenUtils.sig(Void.TYPE, new Class[0]), new MultipleClassInitializer(cls.getClassName(), numChunks));
    }
}

