/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.exception;

import java.util.ArrayList;
import org.dynjs.exception.DynJSException;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.StackElement;

public class ThrowException
extends DynJSException {
    private static final long serialVersionUID = -5523478980527254739L;
    private Object value;
    private ArrayList<StackElement> stack;

    public ThrowException(ExecutionContext context, Throwable value) {
        super(value);
        this.value = value;
        this.setUpStackElements(context);
    }

    public ThrowException(ExecutionContext context, Object value) {
        this.value = value;
        this.setUpStackElements(context);
    }

    protected void setUpStackElements(ExecutionContext context) {
        int i;
        this.stack = new ArrayList();
        context.collectStackElements(this.stack);
        int stackSize = this.stack.size();
        StackTraceElement[] javaElements = this.getStackTrace();
        StackTraceElement[] elements = new StackTraceElement[javaElements.length + stackSize];
        for (i = 0; i < stackSize; ++i) {
            StackElement e = this.stack.get(i);
            String cn = "<global>";
            String fn = null;
            int dotLoc = e.debugContext.indexOf(".");
            if (dotLoc > 0) {
                cn = e.debugContext.substring(0, dotLoc);
                fn = e.debugContext.substring(dotLoc + 1);
            } else {
                fn = e.debugContext;
            }
            elements[i] = new StackTraceElement(cn, fn, e.fileName, e.lineNumber);
        }
        for (i = 0; i < javaElements.length; ++i) {
            elements[i + stackSize] = javaElements[i];
        }
        this.setStackTrace(elements);
    }

    @Override
    public String getMessage() {
        if (this.value instanceof JSObject) {
            String message = "";
            if (((JSObject)this.value).hasProperty(null, "name")) {
                message = message + ((JSObject)this.value).get(null, "name") + ": ";
            }
            if (((JSObject)this.value).hasProperty(null, "message")) {
                message = message + ((JSObject)this.value).get(null, "message");
            }
            return message;
        }
        if (this.value instanceof String) {
            return this.value.toString();
        }
        return super.getMessage();
    }

    public Object getValue() {
        return this.value;
    }
}

