/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.dynjs.parser.ast.AbstractExpression;
import org.dynjs.parser.ast.Expression;
import org.dynjs.parser.ast.FunctionDeclaration;
import org.dynjs.parser.js.Position;

public abstract class AbstractBinaryExpression
extends AbstractExpression {
    private Expression lhs;
    private Expression rhs;
    private String op;

    AbstractBinaryExpression(Expression lhs, Expression rhs, String op) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.op = op;
    }

    @Override
    public Position getPosition() {
        if (this.lhs == null) {
            System.err.println("NULL: " + this.getClass());
        }
        return this.lhs.getPosition();
    }

    public Expression getLhs() {
        return this.lhs;
    }

    public Expression getRhs() {
        return this.rhs;
    }

    public String getOp() {
        return this.op;
    }

    @Override
    public List<FunctionDeclaration> getFunctionDeclarations() {
        ArrayList<FunctionDeclaration> decls = new ArrayList<FunctionDeclaration>();
        decls.addAll(this.lhs.getFunctionDeclarations());
        decls.addAll(this.rhs.getFunctionDeclarations());
        return decls;
    }

    @Override
    public String dump(String indent) {
        return super.dump(indent) + this.lhs.dump(indent + "  ") + "\n" + this.rhs.dump(indent + "  ");
    }

    public String toString() {
        return this.lhs + " " + this.op + " " + this.rhs;
    }

    @Override
    public int getSizeMetric() {
        return this.lhs.getSizeMetric() + this.rhs.getSizeMetric() + 1;
    }
}

