/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.qmx.jitescript.CodeBlock;
import me.qmx.jitescript.util.CodegenUtils;
import org.dynjs.parser.Statement;
import org.dynjs.parser.ast.FunctionDeclaration;
import org.dynjs.parser.ast.VariableDeclaration;
import org.dynjs.runtime.Completion;
import org.objectweb.asm.tree.LabelNode;

public abstract class AbstractStatement
implements Statement {
    private static final AtomicInteger counter = new AtomicInteger();
    private int number;
    private List<String> labels = new ArrayList<String>();

    AbstractStatement() {
        this.number = counter.incrementAndGet();
    }

    @Override
    public int getStatementNumber() {
        return this.number;
    }

    @Override
    public void addLabel(String label) {
        this.labels.add(label);
    }

    @Override
    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    public List<FunctionDeclaration> getFunctionDeclarations() {
        return Collections.emptyList();
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        return Collections.emptyList();
    }

    public CodeBlock normalCompletion() {
        return new CodeBlock().invokestatic(CodegenUtils.p(Completion.class), "createNormal", CodegenUtils.sig(Completion.class, new Class[0]));
    }

    public CodeBlock normalCompletionWithValue() {
        return new CodeBlock().invokestatic(CodegenUtils.p(Completion.class), "createNormal", CodegenUtils.sig(Completion.class, Object.class));
    }

    public CodeBlock returnCompletion() {
        return new CodeBlock().invokestatic(CodegenUtils.p(Completion.class), "createReturn", CodegenUtils.sig(Completion.class, Object.class));
    }

    public CodeBlock continueCompletion(String target) {
        CodeBlock codeBlock = new CodeBlock();
        if (target == null) {
            codeBlock.aconst_null();
        } else {
            codeBlock.ldc(target);
        }
        codeBlock.invokestatic(CodegenUtils.p(Completion.class), "createContinue", CodegenUtils.sig(Completion.class, String.class));
        return codeBlock;
    }

    public CodeBlock breakCompletion(String target) {
        CodeBlock codeBlock = new CodeBlock();
        if (target == null) {
            codeBlock.aconst_null();
        } else {
            codeBlock.ldc(target);
        }
        codeBlock.invokestatic(CodegenUtils.p(Completion.class), "createBreak", CodegenUtils.sig(Completion.class, String.class));
        return codeBlock;
    }

    public CodeBlock throwCompletion() {
        return new CodeBlock().invokestatic(CodegenUtils.p(Completion.class), "createThrow", CodegenUtils.sig(Completion.class, Object.class));
    }

    public CodeBlock handleCompletion(LabelNode normalTarget, LabelNode breakTarget, LabelNode continueTarget, LabelNode returnTarget) {
        return new CodeBlock().append(this.jsCompletionType()).lookupswitch(normalTarget, new int[]{Completion.Type.NORMAL.ordinal(), Completion.Type.BREAK.ordinal(), Completion.Type.CONTINUE.ordinal(), Completion.Type.RETURN.ordinal()}, new LabelNode[]{normalTarget, breakTarget, continueTarget, returnTarget});
    }

    public CodeBlock convertToNormal() {
        return new CodeBlock().dup().getstatic(CodegenUtils.p(Completion.Type.class), "NORMAL", CodegenUtils.ci(Completion.Type.class)).putfield(CodegenUtils.p(Completion.class), "type", CodegenUtils.ci(Completion.Type.class));
    }

    public CodeBlock jsCompletionValue() {
        return new CodeBlock().getfield(CodegenUtils.p(Completion.class), "value", CodegenUtils.ci(Object.class));
    }

    public CodeBlock jsCompletionTarget() {
        return new CodeBlock().getfield(CodegenUtils.p(Completion.class), "target", CodegenUtils.ci(String.class));
    }

    public CodeBlock jsCompletionType() {
        return new CodeBlock().getfield(CodegenUtils.p(Completion.class), "type", CodegenUtils.ci(Completion.Type.class)).invokevirtual(CodegenUtils.p(Completion.Type.class), "ordinal", CodegenUtils.sig(Integer.TYPE, new Class[0]));
    }

    @Override
    public String dump(String indent) {
        return indent + this.getClass().getName() + "\n";
    }
}

