/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dynjs.parser.CodeVisitor;
import org.dynjs.parser.Statement;
import org.dynjs.parser.ast.AbstractStatement;
import org.dynjs.parser.ast.FunctionDeclaration;
import org.dynjs.parser.ast.VariableDeclaration;
import org.dynjs.parser.ast.VariableStatement;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.ExecutionContext;

public class BlockStatement
extends AbstractStatement {
    private final List<Statement> blockContent;

    public BlockStatement(List<Statement> blockContent) {
        this.blockContent = blockContent;
    }

    @Override
    public Position getPosition() {
        if (this.blockContent.isEmpty()) {
            return null;
        }
        return this.blockContent.get(0).getPosition();
    }

    public List<Statement> getBlockContent() {
        return this.blockContent;
    }

    public List<BlockStatement> getAsChunks(int chunkSize) {
        if (this.blockContent.size() <= chunkSize) {
            return Collections.singletonList(this);
        }
        ArrayList<BlockStatement> chunks = new ArrayList<BlockStatement>();
        int chunkStart = 0;
        int totalStatements = this.blockContent.size();
        while (chunkStart < totalStatements) {
            int chunkEnd = chunkStart + chunkSize;
            if (chunkEnd > totalStatements) {
                chunkEnd = totalStatements;
            }
            chunks.add(new BlockStatement(this.blockContent.subList(chunkStart, chunkEnd)));
            chunkStart = chunkEnd;
        }
        return chunks;
    }

    @Override
    public List<FunctionDeclaration> getFunctionDeclarations() {
        if (this.blockContent == null) {
            return Collections.emptyList();
        }
        ArrayList<FunctionDeclaration> decls = new ArrayList<FunctionDeclaration>();
        for (Statement each : this.blockContent) {
            if (each instanceof FunctionDeclaration) {
                decls.add((FunctionDeclaration)each);
            }
            decls.addAll(each.getFunctionDeclarations());
        }
        return decls;
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        ArrayList<VariableDeclaration> decls = new ArrayList<VariableDeclaration>();
        for (Statement each : this.blockContent) {
            if (each instanceof VariableStatement) {
                VariableStatement statement = (VariableStatement)each;
                decls.addAll(statement.getVariableDeclarations());
                continue;
            }
            if (each instanceof FunctionDeclaration) continue;
            decls.addAll(each.getVariableDeclarations());
        }
        return decls;
    }

    @Override
    public void accept(ExecutionContext context, CodeVisitor visitor, boolean strict) {
        visitor.visit(context, this, strict);
    }

    @Override
    public String dump(String indent) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.dump(indent));
        for (Statement each : this.blockContent) {
            buffer.append(each.dump(indent + "  "));
        }
        return buffer.toString();
    }

    @Override
    public int getSizeMetric() {
        return 3;
    }

    @Override
    public String toIndentedString(String indent) {
        StringBuilder buffer = new StringBuilder();
        for (Statement each : this.blockContent) {
            if (each == null) continue;
            buffer.append(each.toIndentedString(indent));
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

