/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import java.util.List;
import org.dynjs.parser.CodeVisitor;
import org.dynjs.parser.Statement;
import org.dynjs.parser.ast.AbstractIteratingStatement;
import org.dynjs.parser.ast.Expression;
import org.dynjs.parser.ast.VariableDeclaration;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.ExecutionContext;

public class DoWhileStatement
extends AbstractIteratingStatement {
    private final Expression test;
    private final Statement block;

    public DoWhileStatement(Position position, Statement block, Expression test) {
        super(position);
        this.block = block;
        this.test = test;
    }

    public Expression getTest() {
        return this.test;
    }

    public Statement getBlock() {
        return this.block;
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        return this.block.getVariableDeclarations();
    }

    @Override
    public void accept(ExecutionContext context, CodeVisitor visitor, boolean strict) {
        visitor.visit(context, this, strict);
    }

    @Override
    public int getSizeMetric() {
        return this.test.getSizeMetric() + 5;
    }

    @Override
    public String toIndentedString(String indent) {
        StringBuilder buf = new StringBuilder();
        buf.append(indent).append("do {\n");
        buf.append(indent).append("} while (").append(this.test.toString()).append(")");
        return buf.toString();
    }
}

