/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import org.dynjs.parser.CodeVisitor;
import org.dynjs.parser.Statement;
import org.dynjs.parser.ast.AbstractForInStatement;
import org.dynjs.parser.ast.Expression;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.ExecutionContext;

public class ForExprInStatement
extends AbstractForInStatement {
    private final Expression expr;

    public ForExprInStatement(Position position, Expression expr, Expression rhs, Statement block) {
        super(position, rhs, block);
        this.expr = expr;
    }

    public Expression getExpr() {
        return this.expr;
    }

    @Override
    public String toIndentedString(String indent) {
        StringBuilder buf = new StringBuilder();
        buf.append(indent).append("for (").append(this.expr.toString()).append(" in ").append(this.getRhs().toString()).append(") {\n");
        buf.append(this.getBlock().toIndentedString(indent + "  "));
        buf.append(indent).append("}");
        return buf.toString();
    }

    @Override
    public void accept(ExecutionContext context, CodeVisitor visitor, boolean strict) {
        visitor.visit(context, this, strict);
    }

    @Override
    public int getSizeMetric() {
        int size = super.getSizeMetric();
        if (this.expr != null) {
            size += this.expr.getSizeMetric();
        }
        return size;
    }
}

