/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.dynjs.parser.CodeVisitor;
import org.dynjs.parser.Statement;
import org.dynjs.parser.ast.AbstractForStatement;
import org.dynjs.parser.ast.Expression;
import org.dynjs.parser.ast.VariableDeclaration;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.ExecutionContext;

public class ForVarDeclStatement
extends AbstractForStatement {
    private final List<VariableDeclaration> declList;

    public ForVarDeclStatement(Position position, List<VariableDeclaration> declList, Expression test, Expression increment, Statement block) {
        super(position, test, increment, block);
        this.declList = declList;
    }

    public List<VariableDeclaration> getDeclarationList() {
        return this.declList;
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        ArrayList<VariableDeclaration> decls = new ArrayList<VariableDeclaration>();
        decls.addAll(this.declList);
        decls.addAll(super.getVariableDeclarations());
        return decls;
    }

    @Override
    public String toIndentedString(String indent) {
        StringBuilder buf = new StringBuilder();
        buf.append(indent).append("for (").append(this.declList == null ? "" : this.declList).append(" ; ");
        buf.append(this.getTest() == null ? "" : this.getTest().toString()).append(" ; ");
        buf.append(this.getIncrement() == null ? "" : this.getIncrement().toString()).append(") {\n");
        buf.append(this.getBlock().toIndentedString(indent + "  "));
        buf.append(indent).append("}");
        return buf.toString();
    }

    @Override
    public int getSizeMetric() {
        int size = super.getSizeMetric();
        for (VariableDeclaration each : this.declList) {
            size += each.getSizeMetric();
        }
        return size;
    }

    @Override
    public void accept(ExecutionContext context, CodeVisitor visitor, boolean strict) {
        visitor.visit(context, this, strict);
    }
}

