/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import java.util.List;
import org.dynjs.parser.CodeVisitor;
import org.dynjs.parser.ast.AbstractExpression;
import org.dynjs.parser.ast.Expression;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.ExecutionContext;

public class FunctionCallExpression
extends AbstractExpression {
    private final Expression memberExpr;
    private final List<Expression> argExprs;

    public FunctionCallExpression(Expression memberExpr, List<Expression> argExprs) {
        this.memberExpr = memberExpr;
        this.argExprs = argExprs;
    }

    @Override
    public Position getPosition() {
        return this.memberExpr.getPosition();
    }

    public List<Expression> getArgumentExpressions() {
        return this.argExprs;
    }

    public Expression getMemberExpression() {
        return this.memberExpr;
    }

    @Override
    public int getSizeMetric() {
        int size = this.memberExpr.getSizeMetric();
        for (Expression each : this.argExprs) {
            size += each.getSizeMetric();
        }
        return size + 5;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.memberExpr).append("(");
        boolean first = true;
        for (Expression each : this.argExprs) {
            if (!first) {
                buf.append(", ");
            }
            buf.append(each.toString());
            first = false;
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public String dump(String indent) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.dump(indent));
        buffer.append(this.memberExpr.dump(indent + "  "));
        for (Expression arg : this.argExprs) {
            buffer.append(arg.dump(indent + "  - "));
        }
        return buffer.toString();
    }

    @Override
    public void accept(ExecutionContext context, CodeVisitor visitor, boolean strict) {
        visitor.visit(context, this, strict);
    }
}

