/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import java.util.List;
import org.dynjs.parser.CodeVisitor;
import org.dynjs.parser.ast.AbstractStatement;
import org.dynjs.parser.ast.BlockStatement;
import org.dynjs.parser.ast.FunctionDescriptor;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.ExecutionContext;

public class FunctionDeclaration
extends AbstractStatement {
    private FunctionDescriptor descriptor;

    public FunctionDeclaration(FunctionDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public Position getPosition() {
        return this.descriptor.getPosition();
    }

    public String getIdentifier() {
        return this.descriptor.getIdentifier();
    }

    public String[] getFormalParameters() {
        return this.descriptor.getFormalParameterNames();
    }

    public BlockStatement getBlock() {
        return this.descriptor.getBlock();
    }

    public boolean isStrict() {
        return this.descriptor.isStrict();
    }

    @Override
    public int getSizeMetric() {
        return this.descriptor.getSizeMetric();
    }

    public String toString() {
        return this.descriptor.toString();
    }

    @Override
    public List<FunctionDeclaration> getFunctionDeclarations() {
        return this.descriptor.getBlock().getFunctionDeclarations();
    }

    @Override
    public String toIndentedString(String indent) {
        StringBuilder buf = new StringBuilder();
        buf.append(indent).append("function").append(this.descriptor.getIdentifier() == null ? "" : " " + this.descriptor.getIdentifier()).append("(");
        String[] params = this.descriptor.getFormalParameterNames();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(params[i]);
        }
        buf.append(") {\n");
        buf.append(this.descriptor.getBlock().toIndentedString(indent + "  "));
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void accept(ExecutionContext context, CodeVisitor visitor, boolean strict) {
        visitor.visit(context, this, strict);
    }
}

