/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import java.util.List;
import org.dynjs.parser.ast.BlockStatement;
import org.dynjs.parser.ast.Parameter;
import org.dynjs.parser.js.Position;

public class FunctionDescriptor {
    private final Position position;
    private final String identifier;
    private final Parameter[] formalParameters;
    private final BlockStatement block;
    private boolean strict;

    public FunctionDescriptor(Position position, String identifier, List<Parameter> formalParameters, BlockStatement block, boolean strict) {
        this(position, identifier, formalParameters.toArray(new Parameter[formalParameters.size()]), block, strict);
    }

    public FunctionDescriptor(Position position, String identifier, Parameter[] formalParameters, BlockStatement block, boolean strict) {
        this.position = position;
        this.identifier = identifier;
        this.formalParameters = formalParameters;
        this.block = block;
        this.strict = strict;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getFormalParameterNames() {
        String[] names = new String[this.formalParameters.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.formalParameters[i].getIdentifier();
        }
        return names;
    }

    public BlockStatement getBlock() {
        return this.block;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public int getSizeMetric() {
        return this.block.getSizeMetric() + this.formalParameters.length + 5;
    }

    public String toString() {
        return "function " + this.identifier + "(...){...}";
    }
}

