/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.dynjs.parser.CodeVisitor;
import org.dynjs.parser.Statement;
import org.dynjs.parser.ast.BaseStatement;
import org.dynjs.parser.ast.Expression;
import org.dynjs.parser.ast.VariableDeclaration;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.ExecutionContext;

public class IfStatement
extends BaseStatement {
    private final Expression testExpr;
    private final Statement thenBlock;
    private final Statement elseBlock;

    public IfStatement(Position position, Expression testExpr, Statement thenBlock, Statement elseBlock) {
        super(position);
        this.testExpr = testExpr;
        this.thenBlock = thenBlock;
        this.elseBlock = elseBlock;
    }

    public Expression getTest() {
        return this.testExpr;
    }

    public Statement getThenBlock() {
        return this.thenBlock;
    }

    public Statement getElseBlock() {
        return this.elseBlock;
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        ArrayList<VariableDeclaration> decls = new ArrayList<VariableDeclaration>();
        if (this.thenBlock != null) {
            decls.addAll(this.thenBlock.getVariableDeclarations());
        }
        if (this.elseBlock != null) {
            decls.addAll(this.elseBlock.getVariableDeclarations());
        }
        return decls;
    }

    @Override
    public String toIndentedString(String indent) {
        StringBuilder buf = new StringBuilder();
        buf.append(indent).append("if (").append(this.testExpr.toString()).append(") {\n");
        buf.append(this.thenBlock.toIndentedString(indent + "  "));
        if (this.elseBlock != null) {
            buf.append(indent).append("} else {\n").append(this.elseBlock.toIndentedString(indent + "  "));
        }
        buf.append(indent).append("}");
        return buf.toString();
    }

    @Override
    public int getSizeMetric() {
        return this.testExpr.getSizeMetric() + 7;
    }

    @Override
    public void accept(ExecutionContext context, CodeVisitor visitor, boolean strict) {
        visitor.visit(context, this, strict);
    }
}

