/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.dynjs.parser.CodeVisitor;
import org.dynjs.parser.ast.BaseExpression;
import org.dynjs.parser.ast.FunctionDeclaration;
import org.dynjs.parser.ast.NamedValue;
import org.dynjs.parser.ast.PropertyAssignment;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.ExecutionContext;

public class ObjectLiteralExpression
extends BaseExpression {
    private final List<PropertyAssignment> propertyAssignments;

    public ObjectLiteralExpression(Position position, List<PropertyAssignment> propertyAssignments) {
        super(position);
        this.propertyAssignments = propertyAssignments;
    }

    public List<PropertyAssignment> getPropertyAssignments() {
        return this.propertyAssignments;
    }

    @Override
    public List<FunctionDeclaration> getFunctionDeclarations() {
        ArrayList<FunctionDeclaration> decls = new ArrayList<FunctionDeclaration>();
        for (PropertyAssignment each : this.propertyAssignments) {
            if (!(each instanceof NamedValue)) continue;
            decls.addAll(((NamedValue)each).getExpr().getFunctionDeclarations());
        }
        return decls;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{ ");
        boolean first = true;
        for (PropertyAssignment each : this.propertyAssignments) {
            if (!first) {
                buf.append(", ");
            }
            first = false;
            buf.append(each.toString());
        }
        buf.append(" }");
        return buf.toString();
    }

    @Override
    public int getSizeMetric() {
        int size = 0;
        for (PropertyAssignment each : this.propertyAssignments) {
            size += each.getSizeMetric();
        }
        return size + 5;
    }

    @Override
    public void accept(ExecutionContext context, CodeVisitor visitor, boolean strict) {
        visitor.visit(context, this, strict);
    }
}

