/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dynjs.parser.CodeVisitor;
import org.dynjs.parser.ast.BaseExpression;
import org.dynjs.parser.js.Position;
import org.dynjs.parser.js.SyntaxError;
import org.dynjs.runtime.ExecutionContext;

public class RegexpLiteralExpression
extends BaseExpression {
    private String pattern;
    private String flags;

    public RegexpLiteralExpression(Position position, String text) {
        super(position);
        RegexpLiteralExpressionParser parser = RegexpLiteralExpressionParser.parse(text);
        if (parser == null) {
            throw new SyntaxError(position, "Invalid regular expression");
        }
        this.pattern = parser.getPattern();
        this.flags = parser.getFlags();
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getFlags() {
        return this.flags;
    }

    public String toString() {
        return "/" + this.pattern + "/" + this.flags;
    }

    @Override
    public int getSizeMetric() {
        return 3;
    }

    @Override
    public void accept(ExecutionContext context, CodeVisitor visitor, boolean strict) {
        visitor.visit(context, this, strict);
    }

    static class RegexpLiteralExpressionParser {
        private static final String REG_EXP_PATTERN = "^\\/((?:.|\u0085)*)\\/([igm]{0,})$";
        private final String source;
        private final String flags;

        static RegexpLiteralExpressionParser parse(String text) {
            Pattern pattern = Pattern.compile(REG_EXP_PATTERN);
            Matcher matcher = pattern.matcher(text);
            if (matcher.matches()) {
                return new RegexpLiteralExpressionParser(matcher.group(1), matcher.group(2));
            }
            return null;
        }

        private RegexpLiteralExpressionParser(String source, String flags) {
            this.source = source;
            this.flags = flags;
        }

        public String getPattern() {
            return this.source;
        }

        public String getFlags() {
            return this.flags;
        }
    }
}

