/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import java.util.List;
import org.dynjs.parser.CodeVisitor;
import org.dynjs.parser.ast.BaseStatement;
import org.dynjs.parser.ast.VariableDeclaration;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.ExecutionContext;

public class VariableStatement
extends BaseStatement {
    private List<VariableDeclaration> decls;

    public VariableStatement(Position position, List<VariableDeclaration> decls) {
        super(position);
        this.decls = decls;
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        return this.decls;
    }

    @Override
    public String dump(String indent) {
        StringBuilder buf = new StringBuilder();
        buf.append(super.dump(indent));
        for (VariableDeclaration decl : this.decls) {
            buf.append(decl.dump(indent + "  "));
        }
        return buf.toString();
    }

    @Override
    public String toIndentedString(String indent) {
        StringBuilder buf = new StringBuilder();
        buf.append(indent).append("var ");
        boolean first = true;
        for (VariableDeclaration each : this.decls) {
            if (!first) {
                buf.append(", ");
            }
            buf.append(each.toString());
            first = false;
        }
        return buf.toString();
    }

    @Override
    public int getSizeMetric() {
        int size = 0;
        for (VariableDeclaration each : this.decls) {
            size += each.getSizeMetric();
        }
        return size + 2;
    }

    @Override
    public void accept(ExecutionContext context, CodeVisitor visitor, boolean strict) {
        visitor.visit(context, this, strict);
    }
}

