/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.js;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.dynjs.exception.ThrowException;
import org.dynjs.parser.Statement;
import org.dynjs.parser.ast.AbstractBinaryExpression;
import org.dynjs.parser.ast.ArrayLiteralExpression;
import org.dynjs.parser.ast.BlockStatement;
import org.dynjs.parser.ast.BreakStatement;
import org.dynjs.parser.ast.CaseClause;
import org.dynjs.parser.ast.CatchClause;
import org.dynjs.parser.ast.ContinueStatement;
import org.dynjs.parser.ast.DebuggerStatement;
import org.dynjs.parser.ast.DefaultCaseClause;
import org.dynjs.parser.ast.DoWhileStatement;
import org.dynjs.parser.ast.EmptyStatement;
import org.dynjs.parser.ast.Expression;
import org.dynjs.parser.ast.ExpressionStatement;
import org.dynjs.parser.ast.FunctionDeclaration;
import org.dynjs.parser.ast.FunctionDescriptor;
import org.dynjs.parser.ast.FunctionExpression;
import org.dynjs.parser.ast.IdentifierReferenceExpression;
import org.dynjs.parser.ast.IfStatement;
import org.dynjs.parser.ast.NamedValue;
import org.dynjs.parser.ast.ObjectLiteralExpression;
import org.dynjs.parser.ast.Parameter;
import org.dynjs.parser.ast.ProgramTree;
import org.dynjs.parser.ast.PropertyAssignment;
import org.dynjs.parser.ast.PropertyGet;
import org.dynjs.parser.ast.PropertySet;
import org.dynjs.parser.ast.ReturnStatement;
import org.dynjs.parser.ast.StringLiteralExpression;
import org.dynjs.parser.ast.SwitchStatement;
import org.dynjs.parser.ast.ThrowStatement;
import org.dynjs.parser.ast.TryStatement;
import org.dynjs.parser.ast.VariableDeclaration;
import org.dynjs.parser.ast.VariableStatement;
import org.dynjs.parser.ast.WhileStatement;
import org.dynjs.parser.ast.WithStatement;
import org.dynjs.parser.js.ASTFactory;
import org.dynjs.parser.js.ParserContext;
import org.dynjs.parser.js.Position;
import org.dynjs.parser.js.SyntaxError;
import org.dynjs.parser.js.Token;
import org.dynjs.parser.js.TokenStream;
import org.dynjs.parser.js.TokenType;
import org.dynjs.runtime.ExecutionContext;

public class Parser {
    private ExecutionContext executionContext;
    private ASTFactory factory;
    private TokenStream stream;
    private List<ParserContext> context = new ArrayList<ParserContext>();
    private int parens = 0;
    private boolean forceStrict;

    public Parser(ExecutionContext executionContext, ASTFactory factory, TokenStream stream) {
        this.executionContext = executionContext;
        this.factory = factory;
        this.stream = stream;
    }

    public void forceStrict(boolean forceStrict) {
        this.forceStrict = forceStrict;
    }

    public boolean isForceStrict() {
        return this.forceStrict;
    }

    protected TokenType la() {
        return this.stream.peek();
    }

    protected TokenType la(int pos) {
        return this.stream.peek(pos);
    }

    protected Token laToken() {
        return this.stream.peekToken();
    }

    protected Token laToken(int pos) {
        return this.stream.peekToken(pos);
    }

    protected Token laToken(boolean skipSkippable) {
        return this.stream.peekToken(skipSkippable);
    }

    protected Token consume() {
        return this.stream.consume();
    }

    protected Token consume(TokenType type) {
        Token t = this.consume();
        if (t.getType() != type) {
            throw new SyntaxError(t, "expected token " + (Object)((Object)type) + " but was '" + t.getText() + "'");
        }
        return t;
    }

    protected TokenType la(boolean skipSkippable) {
        return this.stream.peek(skipSkippable);
    }

    protected TokenType la(boolean skipSkippable, int pos) {
        return this.stream.peek(skipSkippable, pos);
    }

    protected Token consume(boolean skipSkippable) {
        return this.stream.consume(skipSkippable);
    }

    protected Token consume(boolean skipSkippable, TokenType type) {
        Token t = this.stream.consume(skipSkippable);
        if (t.getType() != type) {
            throw new SyntaxError(t, "expected token " + (Object)((Object)type) + " but was '" + t.getText() + "'");
        }
        return t;
    }

    private void pushContext(ParserContext.ContextType type) {
        ParserContext parent = this.currentContext();
        ParserContext ctx = new ParserContext(parent, type);
        if (this.forceStrict || this.context.size() > 0 && this.currentContext().isStrict()) {
            ctx.setStrict(true);
        }
        this.context.add(ctx);
    }

    private void popContext() {
        this.context.remove(this.context.size() - 1);
    }

    private ParserContext currentContext() {
        if (this.context.isEmpty()) {
            return null;
        }
        return this.context.get(this.context.size() - 1);
    }

    private boolean isValidReturn() {
        return this.currentContext().isValidReturn();
    }

    private boolean isValidBreak(String target) {
        return this.currentContext().isValidBreak(target);
    }

    private boolean isValidContinue(String target) {
        return this.currentContext().isValidContinue(target);
    }

    private boolean isValidIdentifier(Token token) {
        if (this.isReservedWord(token)) {
            return false;
        }
        return !this.currentContext().isStrict() || !this.isStrictFutureReservedWord(token.getText());
    }

    public ProgramTree program() {
        try {
            this.pushContext(ParserContext.ContextType.PROGRAM);
            List<Statement> statements = this.sourceElements();
            ProgramTree programTree = this.factory.program(statements, this.currentContext().isStrict());
            return programTree;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression primaryExpression() {
        TokenType t = this.la();
        Token token = null;
        switch (t) {
            case THIS: {
                return this.factory.thisExpression(this.consume());
            }
            case IDENTIFIER: {
                token = this.consume(TokenType.IDENTIFIER);
                if (!this.isValidIdentifier(token)) {
                    throw new SyntaxError(token, "invalid identifier: " + token.getText());
                }
                return this.factory.identifier(token, token.getText());
            }
            case STRING_LITERAL: {
                token = this.consume(TokenType.STRING_LITERAL);
                if (this.currentContext().isStrict() && token.isEscapedOctalString()) {
                    throw new SyntaxError(token, "octal escapes not allowed in strict mode");
                }
                return this.factory.stringLiteral(token, token.getText(), token.isEscapedString(), token.isContinuedLine());
            }
            case DECIMAL_LITERAL: {
                token = this.consume(TokenType.DECIMAL_LITERAL);
                return this.factory.decimalLiteral(token, token.getText());
            }
            case HEX_LITERAL: {
                token = this.consume(TokenType.HEX_LITERAL);
                return this.factory.hexLiteral(token, token.getText());
            }
            case OCTAL_LITERAL: {
                token = this.consume(TokenType.OCTAL_LITERAL);
                if (this.currentContext().isStrict()) {
                    throw new SyntaxError(token, "octal literals not allowed in strict mode");
                }
                return this.factory.octalLiteral(token, token.getText());
            }
            case REGEXP_LITERAL: {
                token = this.consume(TokenType.REGEXP_LITERAL);
                return this.factory.regexpLiteral(token, token.getText());
            }
            case TRUE: {
                return this.factory.trueLiteral(this.consume());
            }
            case FALSE: {
                return this.factory.falseLiteral(this.consume());
            }
            case NULL: {
                return this.factory.nullLiteral(this.consume());
            }
            case LEFT_BRACE: {
                return this.objectLiteral();
            }
            case LEFT_BRACKET: {
                return this.arrayLiteral();
            }
            case LEFT_PAREN: {
                this.consume(TokenType.LEFT_PAREN);
                try {
                    ++this.parens;
                    Expression expr = this.expression();
                    this.consume(TokenType.RIGHT_PAREN);
                    Expression expression = expr;
                    return expression;
                }
                finally {
                    --this.parens;
                }
            }
        }
        throw new SyntaxError(this.laToken(), "unexpected token: " + this.laToken());
    }

    public Expression expression() {
        return this.expression(false);
    }

    public Expression expressionNoIn() {
        return this.expression(true);
    }

    public Expression expression(boolean noIn) {
        Expression expr = this.assignmentExpression(noIn);
        if (this.la() == TokenType.COMMA) {
            this.consume();
            expr = this.factory.commaOperator(expr, this.expression(noIn));
        }
        return expr;
    }

    public ObjectLiteralExpression objectLiteral() {
        Token position = this.consume(TokenType.LEFT_BRACE);
        ArrayList<PropertyAssignment> propAssignments = new ArrayList<PropertyAssignment>();
        HashSet<String> values = new HashSet<String>();
        HashSet<String> getters = new HashSet<String>();
        HashSet<String> setters = new HashSet<String>();
        while (this.la() != TokenType.RIGHT_BRACE) {
            PropertyAssignment assignment = null;
            Token token = this.laToken();
            switch (token.getText()) {
                case "get": {
                    if (this.la(2) != TokenType.COLON) {
                        assignment = this.propertyGet();
                        propAssignments.add(assignment);
                        if (values.contains(assignment.getName()) || getters.contains(assignment.getName())) {
                            throw new SyntaxError(token, "duplicate property not allowed: " + assignment.getName());
                        }
                        getters.add(assignment.getName());
                        break;
                    }
                }
                case "set": {
                    if (this.la(2) != TokenType.COLON) {
                        assignment = this.propertySet();
                        propAssignments.add(assignment);
                        if (values.contains(assignment.getName()) || setters.contains(assignment.getName())) {
                            throw new SyntaxError(token, "duplicate property not allowed: " + assignment.getName());
                        }
                        setters.add(assignment.getName());
                        break;
                    }
                }
                default: {
                    assignment = this.namedValue();
                    propAssignments.add(assignment);
                    if (getters.contains(assignment.getName()) || setters.contains(assignment.getName())) {
                        throw new SyntaxError(token, "duplicate property not allowed: " + assignment.getName());
                    }
                    if (this.currentContext().isStrict() && values.contains(assignment.getName())) {
                        throw new SyntaxError(token, "duplicate property not allowed: " + assignment.getName());
                    }
                    values.add(assignment.getName());
                }
            }
            if (this.la() != TokenType.COMMA) break;
            this.consume(TokenType.COMMA);
        }
        this.consume(TokenType.RIGHT_BRACE);
        return this.factory.objectLiteral(position, propAssignments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertySet propertySet() {
        try {
            this.pushContext(ParserContext.ContextType.FUNCTION);
            Token set = this.consume(TokenType.IDENTIFIER);
            if (!set.getText().equals("set")) {
                throw new SyntaxError("expected 'set', was: " + set);
            }
            Token token = this.laToken();
            if (!this.isPropertyName(token)) {
                throw new SyntaxError(token, "expected property identifier");
            }
            String name = this.consume().getText();
            this.consume(TokenType.LEFT_PAREN);
            Token param = this.consume(TokenType.IDENTIFIER);
            if (!this.isAssignableName(param.getText())) {
                throw new SyntaxError("invalid parameter name: " + param.getText());
            }
            this.consume(TokenType.RIGHT_PAREN);
            this.consume(TokenType.LEFT_BRACE);
            BlockStatement body = this.functionBody();
            this.consume(TokenType.RIGHT_BRACE);
            PropertySet propertySet = new PropertySet(name, param.getText(), body);
            return propertySet;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyGet propertyGet() {
        try {
            this.pushContext(ParserContext.ContextType.FUNCTION);
            Token get = this.consume(TokenType.IDENTIFIER);
            if (!get.getText().equals("get")) {
                throw new SyntaxError("expected 'get', was: " + get);
            }
            Token token = this.laToken();
            if (!this.isPropertyName(token)) {
                throw new SyntaxError(token, "expected property identifier");
            }
            String name = this.consume().getText();
            this.consume(TokenType.LEFT_PAREN);
            this.consume(TokenType.RIGHT_PAREN);
            this.consume(TokenType.LEFT_BRACE);
            BlockStatement body = this.functionBody();
            this.consume(TokenType.RIGHT_BRACE);
            PropertyGet propertyGet = new PropertyGet(name, body);
            return propertyGet;
        }
        finally {
            this.popContext();
        }
    }

    protected NamedValue namedValue() {
        Token token = this.laToken();
        if (!this.isPropertyName(token)) {
            throw new SyntaxError(token, "expected property identifier");
        }
        String name = this.consume().getText();
        this.consume(TokenType.COLON);
        Expression expr = this.assignmentExpression();
        return new NamedValue(name, expr);
    }

    protected boolean isPropertyName(Token token) {
        switch (token.getType()) {
            case IDENTIFIER: 
            case STRING_LITERAL: 
            case DECIMAL_LITERAL: 
            case HEX_LITERAL: {
                return true;
            }
        }
        return this.isReservedWord(token);
    }

    protected boolean isAssignableName(String name) {
        if (this.isFutureReservedWord(name)) {
            return false;
        }
        return !this.currentContext().isStrict() || !this.isStrictFutureReservedWord(name) && !name.equals("arguments") && !name.equals("eval");
    }

    protected boolean isReservedWord(Token token) {
        return this.isKeyword(token.getType()) || this.isFutureReservedWord(token.getText());
    }

    protected boolean isKeyword(TokenType type) {
        switch (type) {
            case THIS: 
            case TRUE: 
            case FALSE: 
            case NULL: 
            case BREAK: 
            case DO: 
            case INSTANCEOF: 
            case TYPEOF: 
            case CASE: 
            case ELSE: 
            case NEW: 
            case VAR: 
            case CATCH: 
            case FINALLY: 
            case RETURN: 
            case VOID: 
            case CONTINUE: 
            case FOR: 
            case SWITCH: 
            case WHILE: 
            case DEBUGGER: 
            case FUNCTION: 
            case WITH: 
            case DEFAULT: 
            case IF: 
            case THROW: 
            case DELETE: 
            case IN: 
            case TRY: {
                return true;
            }
        }
        return false;
    }

    protected boolean isFutureReservedWord(String name) {
        switch (name) {
            case "class": 
            case "enum": 
            case "extends": 
            case "super": 
            case "const": 
            case "export": 
            case "import": {
                return true;
            }
        }
        return false;
    }

    protected boolean isStrictFutureReservedWord(String name) {
        switch (name) {
            case "implements": 
            case "let": 
            case "private": 
            case "public": 
            case "yield": 
            case "interface": 
            case "package": 
            case "protected": 
            case "static": {
                return true;
            }
        }
        return false;
    }

    public ArrayLiteralExpression arrayLiteral() {
        Token start = this.consume(TokenType.LEFT_BRACKET);
        ArrayList<Expression> exprs = new ArrayList<Expression>();
        while (this.la() != TokenType.RIGHT_BRACKET) {
            if (this.la() == TokenType.COMMA) {
                this.consume();
                exprs.add(null);
                continue;
            }
            exprs.add(this.assignmentExpression());
            if (this.la() != TokenType.COMMA) break;
            this.consume();
        }
        this.consume(TokenType.RIGHT_BRACKET);
        return this.factory.arrayLiteral(start, exprs);
    }

    public Expression assignmentExpression() {
        return this.assignmentExpression(false);
    }

    public Expression assignmentExpressionNoIn() {
        return this.assignmentExpression(true);
    }

    public Expression assignmentExpression(boolean noIn) {
        String ident;
        Expression lhs;
        Expression expr = this.conditionalExpression(noIn);
        switch (this.la()) {
            case EQUALS: {
                this.consume(TokenType.EQUALS);
                this.checkAssignmentLHS(expr);
                expr = this.factory.assignmentOperator(expr, this.assignmentExpression(noIn));
                break;
            }
            case MULTIPLY_EQUALS: {
                this.consume(TokenType.MULTIPLY_EQUALS);
                this.checkAssignmentLHS(expr);
                expr = this.factory.multiplicationAssignmentOperator(expr, this.assignmentExpression(noIn));
                break;
            }
            case DIVIDE_EQUALS: {
                this.consume(TokenType.DIVIDE_EQUALS);
                this.checkAssignmentLHS(expr);
                expr = this.factory.divisionAssignmentOperator(expr, this.assignmentExpression(noIn));
                break;
            }
            case MODULO_EQUALS: {
                this.consume(TokenType.MODULO_EQUALS);
                this.checkAssignmentLHS(expr);
                expr = this.factory.moduloAssignmentOperator(expr, this.assignmentExpression(noIn));
                break;
            }
            case PLUS_EQUALS: {
                this.consume(TokenType.PLUS_EQUALS);
                this.checkAssignmentLHS(expr);
                expr = this.factory.additionAssignmentOperator(expr, this.assignmentExpression(noIn));
                break;
            }
            case MINUS_EQUALS: {
                this.consume(TokenType.MINUS_EQUALS);
                this.checkAssignmentLHS(expr);
                expr = this.factory.subtractionAssignmentOperator(expr, this.assignmentExpression(noIn));
                break;
            }
            case LEFT_SHIFT_EQUALS: {
                this.consume(TokenType.LEFT_SHIFT_EQUALS);
                this.checkAssignmentLHS(expr);
                expr = this.factory.leftShiftAssignmentOperator(expr, this.assignmentExpression(noIn));
                break;
            }
            case RIGHT_SHIFT_EQUALS: {
                this.consume(TokenType.RIGHT_SHIFT_EQUALS);
                this.checkAssignmentLHS(expr);
                expr = this.factory.rightShiftAssignmentOperator(expr, this.assignmentExpression(noIn));
                break;
            }
            case UNSIGNED_RIGHT_SHIFT_EQUALS: {
                this.consume(TokenType.UNSIGNED_RIGHT_SHIFT_EQUALS);
                this.checkAssignmentLHS(expr);
                expr = this.factory.unsignedRightShiftAssignmentOperator(expr, this.assignmentExpression(noIn));
                break;
            }
            case BITWISE_AND_EQUALS: {
                this.consume(TokenType.BITWISE_AND_EQUALS);
                this.checkAssignmentLHS(expr);
                expr = this.factory.bitwiseAndAssignmentOperator(expr, this.assignmentExpression(noIn));
                break;
            }
            case BITWISE_OR_EQUALS: {
                this.consume(TokenType.BITWISE_OR_EQUALS);
                this.checkAssignmentLHS(expr);
                expr = this.factory.bitwiseOrAssignmentOperator(expr, this.assignmentExpression(noIn));
                break;
            }
            case BITWISE_XOR_EQUALS: {
                this.consume(TokenType.BITWISE_XOR_EQUALS);
                this.checkAssignmentLHS(expr);
                expr = this.factory.bitwiseXorAssignmentOperator(expr, this.assignmentExpression(noIn));
                break;
            }
            default: {
                return expr;
            }
        }
        if (this.currentContext().isStrict() && expr instanceof AbstractBinaryExpression && (lhs = ((AbstractBinaryExpression)expr).getLhs()) instanceof IdentifierReferenceExpression && !this.isAssignableName(ident = ((IdentifierReferenceExpression)lhs).getIdentifier())) {
            throw new SyntaxError(expr.getPosition(), "invalid identifier for strict-mode: " + ident);
        }
        return expr;
    }

    protected void checkAssignmentLHS(Expression expr) {
        String id;
        if (this.currentContext().isStrict() && expr instanceof IdentifierReferenceExpression && ((id = ((IdentifierReferenceExpression)expr).getIdentifier()).equals("eval") || id.equals("arguments"))) {
            throw new ThrowException(this.executionContext, this.executionContext.createSyntaxError(id + " may not appear on the left-hand-side of a compound assignment expression in strict mode"));
        }
    }

    public Expression conditionalExpression(boolean noIn) {
        Expression expr = this.logicalOrExpression(noIn);
        if (this.la() == TokenType.QUESTION) {
            this.consume(TokenType.QUESTION);
            Expression thenExpr = this.assignmentExpression(noIn);
            this.consume(TokenType.COLON);
            Expression elseExpr = this.assignmentExpression(noIn);
            return this.factory.ternaryOperator(expr, thenExpr, elseExpr);
        }
        return expr;
    }

    public Expression logicalOrExpression(boolean noIn) {
        Expression expr = this.logicalAndExpression(noIn);
        while (this.la() == TokenType.LOGICAL_OR) {
            this.consume(TokenType.LOGICAL_OR);
            expr = this.factory.logicalOrOperator(expr, this.logicalAndExpression(noIn));
        }
        return expr;
    }

    public Expression logicalAndExpression(boolean noIn) {
        Expression expr = this.bitwiseOrExpression(noIn);
        while (this.la() == TokenType.LOGICAL_AND) {
            this.consume(TokenType.LOGICAL_AND);
            expr = this.factory.logicalAndOperator(expr, this.bitwiseOrExpression(noIn));
        }
        return expr;
    }

    public Expression bitwiseOrExpression(boolean noIn) {
        Expression expr = this.bitwiseXorExpression(noIn);
        while (this.la() == TokenType.BITWISE_OR) {
            this.consume(TokenType.BITWISE_OR);
            expr = this.factory.bitwiseOrOperator(expr, this.bitwiseXorExpression(noIn));
        }
        return expr;
    }

    public Expression bitwiseXorExpression(boolean noIn) {
        Expression expr = this.bitwiseAndExpression(noIn);
        while (this.la() == TokenType.BITWISE_XOR) {
            this.consume(TokenType.BITWISE_XOR);
            expr = this.factory.bitwiseXorOperator(expr, this.bitwiseAndExpression(noIn));
        }
        return expr;
    }

    public Expression bitwiseAndExpression(boolean noIn) {
        Expression expr = this.equalityExpression(noIn);
        while (this.la() == TokenType.BITWISE_AND) {
            this.consume(TokenType.BITWISE_AND);
            expr = this.factory.bitwiseAndOperator(expr, this.equalityExpression(noIn));
        }
        return expr;
    }

    public Expression equalityExpression(boolean noIn) {
        Expression expr = this.relationalExpression(noIn);
        while (this.la() == TokenType.EQUALITY || this.la() == TokenType.NOT_EQUALITY || this.la() == TokenType.STRICT_EQUALITY || this.la() == TokenType.STRICT_NOT_EQUALITY) {
            switch (this.la()) {
                case EQUALITY: {
                    this.consume();
                    expr = this.factory.equalityOperator(expr, this.relationalExpression(noIn));
                    break;
                }
                case NOT_EQUALITY: {
                    this.consume();
                    expr = this.factory.notEqualityOperator(expr, this.relationalExpression(noIn));
                    break;
                }
                case STRICT_EQUALITY: {
                    this.consume();
                    expr = this.factory.strictEqualityOperator(expr, this.relationalExpression(noIn));
                    break;
                }
                case STRICT_NOT_EQUALITY: {
                    this.consume();
                    expr = this.factory.strictNotEqualityOperator(expr, this.relationalExpression(noIn));
                }
            }
        }
        return expr;
    }

    public Expression relationalExpression(boolean noIn) {
        Expression expr = this.shiftExpression();
        while (this.la() == TokenType.LESS_THAN || this.la() == TokenType.LESS_THAN_EQUAL || this.la() == TokenType.GREATER_THAN || this.la() == TokenType.GREATER_THAN_EQUAL || this.la() == TokenType.INSTANCEOF || !noIn && this.la() == TokenType.IN) {
            switch (this.la()) {
                case LESS_THAN: {
                    this.consume();
                    expr = this.factory.lessThanOperator(expr, this.shiftExpression());
                    break;
                }
                case LESS_THAN_EQUAL: {
                    this.consume();
                    expr = this.factory.lessThanEqualOperator(expr, this.shiftExpression());
                    break;
                }
                case GREATER_THAN: {
                    this.consume();
                    expr = this.factory.greaterThanOperator(expr, this.shiftExpression());
                    break;
                }
                case GREATER_THAN_EQUAL: {
                    this.consume();
                    expr = this.factory.greaterThanEqualOperator(expr, this.shiftExpression());
                    break;
                }
                case INSTANCEOF: {
                    this.consume();
                    expr = this.factory.instanceofOperator(expr, this.shiftExpression());
                    break;
                }
                case IN: {
                    if (noIn) break;
                    this.consume();
                    expr = this.factory.inOperator(expr, this.shiftExpression());
                }
            }
        }
        return expr;
    }

    public Expression shiftExpression() {
        Expression expr = this.additiveExpression();
        while (this.la() == TokenType.LEFT_SHIFT || this.la() == TokenType.RIGHT_SHIFT || this.la() == TokenType.UNSIGNED_RIGHT_SHIFT) {
            switch (this.la()) {
                case LEFT_SHIFT: {
                    this.consume();
                    expr = this.factory.leftShiftOperator(expr, this.additiveExpression());
                    break;
                }
                case RIGHT_SHIFT: {
                    this.consume();
                    expr = this.factory.rightShiftOperator(expr, this.additiveExpression());
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT: {
                    this.consume();
                    expr = this.factory.unsignedRightShiftOperator(expr, this.additiveExpression());
                }
            }
        }
        return expr;
    }

    public Expression additiveExpression() {
        Expression expr = this.multiplicativeExpression();
        while (this.la() == TokenType.PLUS || this.la() == TokenType.MINUS) {
            switch (this.la()) {
                case PLUS: {
                    this.consume();
                    expr = this.factory.additionOperator(expr, this.multiplicativeExpression());
                    break;
                }
                case MINUS: {
                    this.consume();
                    expr = this.factory.subtractionOperator(expr, this.multiplicativeExpression());
                }
            }
        }
        return expr;
    }

    public Expression multiplicativeExpression() {
        Expression expr = this.unaryExpression();
        while (this.la() == TokenType.MULTIPLY || this.la() == TokenType.DIVIDE || this.la() == TokenType.MODULO) {
            switch (this.la()) {
                case MULTIPLY: {
                    this.consume();
                    expr = this.factory.multiplicationOperator(expr, this.unaryExpression());
                    break;
                }
                case DIVIDE: {
                    this.consume();
                    expr = this.factory.divisionOperator(expr, this.unaryExpression());
                    break;
                }
                case MODULO: {
                    this.consume();
                    expr = this.factory.moduloOperator(expr, this.unaryExpression());
                }
            }
        }
        return expr;
    }

    public Expression unaryExpression() {
        Expression expr = null;
        switch (this.la()) {
            case DELETE: {
                this.consume();
                expr = this.unaryExpression();
                if (this.currentContext().isStrict() && expr instanceof IdentifierReferenceExpression) {
                    throw new ThrowException(this.executionContext, this.executionContext.createSyntaxError("cannot delete a direct reference in strict-mode"));
                }
                return this.factory.deleteOperator(expr);
            }
            case VOID: {
                this.consume();
                return this.factory.voidOperator(this.unaryExpression());
            }
            case TYPEOF: {
                this.consume();
                return this.factory.typeofOperator(this.unaryExpression());
            }
            case PLUS_PLUS: {
                this.consume();
                expr = this.unaryExpression();
                this.checkAssignmentLHS(expr);
                return this.factory.preIncrementOperator(expr);
            }
            case MINUS_MINUS: {
                this.consume();
                expr = this.unaryExpression();
                this.checkAssignmentLHS(expr);
                return this.factory.preDecrementOperator(expr);
            }
            case PLUS: {
                this.consume();
                return this.factory.unaryPlusOperator(this.unaryExpression());
            }
            case MINUS: {
                this.consume();
                return this.factory.unaryMinusOperator(this.unaryExpression());
            }
            case INVERSION: {
                this.consume();
                return this.factory.bitwiseInversionOperator(this.unaryExpression());
            }
            case NOT: {
                this.consume();
                return this.factory.unaryNotOperator(this.unaryExpression());
            }
        }
        return this.postfixExpression();
    }

    public Expression postfixExpression() {
        Expression expr = this.leftHandSideExpression();
        switch (this.la(false)) {
            case PLUS_PLUS: {
                this.checkAssignmentLHS(expr);
                this.consume(false);
                return this.factory.postIncrementOperator(expr);
            }
            case MINUS_MINUS: {
                this.checkAssignmentLHS(expr);
                this.consume(false);
                return this.factory.postDecrementOperator(expr);
            }
        }
        return expr;
    }

    public Expression leftHandSideExpression() {
        if (this.la() == TokenType.NEW) {
            return this.newExpression();
        }
        return this.callExpression();
    }

    public Expression memberExpression() {
        Expression expr = null;
        expr = this.la() == TokenType.FUNCTION ? this.functionExpression() : this.primaryExpression();
        block4: while (true) {
            switch (this.la()) {
                case DOT: {
                    this.consume(TokenType.DOT);
                    Token token = this.laToken();
                    if (!this.isPropertyName(token)) {
                        throw new SyntaxError(token, "expected property name");
                    }
                    String identifier = this.consume().getText();
                    expr = this.factory.dotOperator(expr, identifier);
                    continue block4;
                }
                case LEFT_BRACKET: {
                    this.consume(TokenType.LEFT_BRACKET);
                    expr = this.factory.bracketOperator(expr, this.expression());
                    this.consume(TokenType.RIGHT_BRACKET);
                    continue block4;
                }
            }
            break;
        }
        return expr;
    }

    public Expression callExpression() {
        Expression expr = this.memberExpression();
        block5: while (true) {
            switch (this.la()) {
                case DOT: {
                    this.consume(TokenType.DOT);
                    String identifier = this.consume(TokenType.IDENTIFIER).getText();
                    expr = this.factory.dotOperator(expr, identifier);
                    continue block5;
                }
                case LEFT_BRACKET: {
                    this.consume(TokenType.LEFT_BRACKET);
                    expr = this.factory.bracketOperator(expr, this.expression());
                    this.consume(TokenType.RIGHT_BRACKET);
                    continue block5;
                }
                case LEFT_PAREN: {
                    List<Expression> args = this.arguments();
                    expr = this.factory.functionCall(expr, args);
                    continue block5;
                }
            }
            break;
        }
        return expr;
    }

    public Expression newExpression() {
        this.consume(TokenType.NEW);
        Expression expr = null;
        if (this.la() == TokenType.NEW) {
            expr = this.factory.newOperator(this.newExpression());
        } else {
            expr = this.memberExpression();
            if (this.la() == TokenType.LEFT_PAREN) {
                List<Expression> args = this.arguments();
                expr = this.factory.newOperator(expr, args);
            } else {
                expr = this.factory.newOperator(expr);
            }
        }
        block5: while (true) {
            switch (this.la()) {
                case DOT: {
                    this.consume(TokenType.DOT);
                    String identifier = this.consume(TokenType.IDENTIFIER).getText();
                    expr = this.factory.dotOperator(expr, identifier);
                    continue block5;
                }
                case LEFT_BRACKET: {
                    this.consume(TokenType.LEFT_BRACKET);
                    expr = this.factory.bracketOperator(expr, this.expression());
                    this.consume(TokenType.RIGHT_BRACKET);
                    continue block5;
                }
                case LEFT_PAREN: {
                    List<Expression> args = this.arguments();
                    expr = this.factory.functionCall(expr, args);
                    continue block5;
                }
            }
            break;
        }
        return expr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionExpression functionExpression() {
        boolean isContainingValidForFunctionDecls = this.currentContext().isValidForFunctionDeclaration();
        try {
            this.pushContext(ParserContext.ContextType.FUNCTION);
            Token position = this.consume(TokenType.FUNCTION);
            Token identifier = null;
            String identifierName = null;
            if (this.la() == TokenType.IDENTIFIER) {
                identifier = this.consume(TokenType.IDENTIFIER);
                if (!this.isAssignableName(identifier.getText())) {
                    throw new SyntaxError(identifier, "invalid identifier: " + identifier.getText());
                }
                identifierName = identifier.getText();
            }
            if (identifierName != null && this.parens == 0 && !isContainingValidForFunctionDecls) {
                throw new ThrowException(this.executionContext, this.executionContext.createSyntaxError("cannot use function-declarations here"));
            }
            List<Parameter> params = this.formalParameters();
            this.consume(TokenType.LEFT_BRACE);
            BlockStatement body = this.functionBody();
            this.consume(TokenType.RIGHT_BRACE);
            FunctionExpression functionExpression = this.factory.functionExpression(position, identifierName, params, body, this.currentContext().isStrict());
            return functionExpression;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionDeclaration functionDeclaration() {
        try {
            this.pushContext(ParserContext.ContextType.FUNCTION);
            Token position = this.consume(TokenType.FUNCTION);
            Token identifier = this.consume(TokenType.IDENTIFIER);
            if (!this.isAssignableName(identifier.getText())) {
                throw new SyntaxError(identifier, "invalid identifier: " + identifier.getText());
            }
            List<Parameter> params = this.formalParameters();
            this.consume(TokenType.LEFT_BRACE);
            BlockStatement body = this.functionBody();
            this.consume(TokenType.RIGHT_BRACE);
            FunctionDeclaration functionDeclaration = this.factory.functionDeclaration(position, identifier.getText(), params, body, this.currentContext().isStrict());
            return functionDeclaration;
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionDescriptor functionDescriptor() {
        try {
            this.pushContext(ParserContext.ContextType.FUNCTION);
            Token position = this.consume(TokenType.FUNCTION);
            String identifier = null;
            if (this.la() == TokenType.IDENTIFIER) {
                identifier = this.consume(TokenType.IDENTIFIER).getText();
            }
            List<Parameter> params = this.formalParameters();
            this.consume(TokenType.LEFT_BRACE);
            BlockStatement body = this.functionBody();
            this.consume(TokenType.RIGHT_BRACE);
            FunctionDescriptor functionDescriptor = new FunctionDescriptor((Position)position, identifier, params, body, this.currentContext().isStrict());
            return functionDescriptor;
        }
        finally {
            this.popContext();
        }
    }

    public BlockStatement functionBody() {
        List<Statement> statements = this.sourceElements();
        return this.factory.block(statements);
    }

    public List<Parameter> formalParameters() {
        this.consume(TokenType.LEFT_PAREN);
        List<Parameter> params = this.formalParameterList();
        this.consume(TokenType.RIGHT_PAREN);
        return params;
    }

    public List<Parameter> formalParameterList() {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        while (this.la() != TokenType.RIGHT_PAREN) {
            params.add(this.parameter());
            if (this.la() != TokenType.COMMA) break;
            this.consume();
        }
        if (this.currentContext().isStrict()) {
            HashSet<String> seen = new HashSet<String>();
            for (Parameter each : params) {
                if (seen.contains(each.getIdentifier())) {
                    throw new SyntaxError(each.getPosition(), "duplicate formal parameters not allowed in strict-mode");
                }
                seen.add(each.getIdentifier());
            }
        }
        return params;
    }

    public Parameter parameter() {
        Token identifier = this.consume(TokenType.IDENTIFIER);
        if (!this.isAssignableName(identifier.getText())) {
            throw new SyntaxError(identifier, "invalid formal parameter:" + identifier.getText());
        }
        return this.factory.parameter(identifier, identifier.getText());
    }

    public List<Expression> arguments() {
        this.consume(TokenType.LEFT_PAREN);
        List<Expression> args = this.argumentList();
        this.consume(TokenType.RIGHT_PAREN);
        return args;
    }

    public List<Expression> argumentList() {
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        while (this.la() != TokenType.RIGHT_PAREN) {
            arguments.add(this.assignmentExpression());
            if (this.la() != TokenType.COMMA) break;
            this.consume();
        }
        return arguments;
    }

    public List<Statement> sourceElements() {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        while (this.la() != TokenType.EOF && this.la() != TokenType.RIGHT_BRACE) {
            Statement element = this.sourceElement();
            if (this.currentContext().isInProlog()) {
                if (element instanceof ExpressionStatement) {
                    Expression expr = ((ExpressionStatement)element).getExpr();
                    if (expr instanceof StringLiteralExpression) {
                        if (((StringLiteralExpression)expr).getLiteral().equals("use strict") && !((StringLiteralExpression)expr).isContinuedLine() && !((StringLiteralExpression)expr).isEscaped()) {
                            this.currentContext().setStrict(true);
                        }
                    } else {
                        this.currentContext().setInProlog(false);
                    }
                } else {
                    this.currentContext().setInProlog(false);
                }
            }
            statements.add(element);
        }
        return statements;
    }

    public Statement sourceElement() {
        if (this.la() == TokenType.FUNCTION) {
            return this.functionDeclaration();
        }
        return this.statement();
    }

    public Statement statement() {
        switch (this.la()) {
            case LEFT_BRACE: {
                return this.block();
            }
            case VAR: {
                return this.variableStatement();
            }
            case SEMICOLON: {
                return this.emptyStatement();
            }
            case IF: {
                return this.ifStatement();
            }
            case DO: 
            case FOR: 
            case WHILE: {
                return this.iterationStatement();
            }
            case CONTINUE: {
                return this.continueStatement();
            }
            case BREAK: {
                return this.breakStatement();
            }
            case RETURN: {
                return this.returnStatement();
            }
            case WITH: {
                return this.withStatement();
            }
            case SWITCH: {
                return this.switchStatement();
            }
            case THROW: {
                return this.throwStatement();
            }
            case TRY: {
                return this.tryStatement();
            }
            case DEBUGGER: {
                return this.debuggerStatement();
            }
            case FUNCTION: {
                if (this.currentContext().isStrict()) {
                    throw new SyntaxError("function declaration in statement not allowed in strict-mode code");
                }
                return this.functionDeclaration();
            }
        }
        if (this.la(2) == TokenType.COLON) {
            return this.labelledStatement();
        }
        return this.expressionStatement();
    }

    protected void semic() {
        if (this.la() == TokenType.EOF) {
            return;
        }
        if (this.la() == TokenType.RIGHT_BRACE) {
            return;
        }
        if (this.la() == TokenType.SEMICOLON) {
            this.consume(TokenType.SEMICOLON);
        } else {
            Token next = this.consume(false);
            switch (next.getType()) {
                case CRNL: 
                case CR: 
                case NL: 
                case PARAGRAPH_SEPARATOR: 
                case LINE_SEPARATOR: {
                    break;
                }
                default: {
                    throw new SyntaxError(next, "semicolon expected but saw: " + next);
                }
            }
        }
    }

    public BlockStatement block() {
        try {
            this.pushContext(ParserContext.ContextType.OTHER);
            this.consume(TokenType.LEFT_BRACE);
            ArrayList<Statement> statements = new ArrayList<Statement>();
            while (this.la() != TokenType.RIGHT_BRACE) {
                statements.add(this.statement());
            }
            this.consume(TokenType.RIGHT_BRACE);
            BlockStatement blockStatement = this.factory.block(statements);
            return blockStatement;
        }
        finally {
            this.popContext();
        }
    }

    public VariableStatement variableStatement() {
        return this.variableStatement(false);
    }

    public VariableStatement variableStatementNoIn() {
        return this.variableStatement(true);
    }

    public VariableStatement variableStatement(boolean noIn) {
        Token position = this.consume(TokenType.VAR);
        List<VariableDeclaration> decls = this.variableDeclarationList(noIn);
        this.semic();
        return this.factory.variableStatement(position, decls);
    }

    protected List<VariableDeclaration> variableDeclarationList(boolean noIn) {
        ArrayList<VariableDeclaration> decls = new ArrayList<VariableDeclaration>();
        decls.add(this.variableDeclaration(noIn));
        while (this.la() == TokenType.COMMA) {
            this.consume(TokenType.COMMA);
            decls.add(this.variableDeclaration(noIn));
        }
        return decls;
    }

    public VariableDeclaration variableDeclaration(boolean noIn) {
        Token identifier = this.consume(TokenType.IDENTIFIER);
        if (!this.isValidIdentifier(identifier) || !this.isAssignableName(identifier.getText())) {
            throw new SyntaxError(identifier, "invalid identifier: " + identifier.getText());
        }
        Expression initializer = null;
        if (this.la() == TokenType.EQUALS) {
            this.consume(TokenType.EQUALS);
            initializer = this.assignmentExpression(noIn);
        }
        return this.factory.variableDeclaration(identifier, identifier.getText(), initializer);
    }

    public EmptyStatement emptyStatement() {
        Token position = this.consume(TokenType.SEMICOLON);
        return this.factory.emptyStatement(position);
    }

    public ExpressionStatement expressionStatement() {
        Expression expr = this.expression();
        this.semic();
        return this.factory.expressionStatement(expr);
    }

    public IfStatement ifStatement() {
        Token position = this.consume(TokenType.IF);
        this.consume(TokenType.LEFT_PAREN);
        Expression testExpr = this.expression();
        this.consume(TokenType.RIGHT_PAREN);
        Statement body = this.statement();
        if (this.la() == TokenType.ELSE) {
            this.consume(TokenType.ELSE);
            Statement elseBody = this.statement();
            return this.factory.ifStatement(position, testExpr, body, elseBody);
        }
        return this.factory.ifStatement(position, testExpr, body);
    }

    public ContinueStatement continueStatement() {
        Token position = this.consume(TokenType.CONTINUE);
        String target = null;
        switch (this.la(false)) {
            case SEMICOLON: 
            case CRNL: 
            case CR: 
            case NL: 
            case PARAGRAPH_SEPARATOR: 
            case LINE_SEPARATOR: 
            case RIGHT_BRACE: {
                break;
            }
            case IDENTIFIER: {
                target = this.consume(TokenType.IDENTIFIER).getText();
                break;
            }
            default: {
                throw new SyntaxError(this.laToken(false), "unexpected token: " + this.laToken(false).getText());
            }
        }
        if (!this.isValidContinue(target)) {
            if (target == null) {
                throw new SyntaxError(position, "continue not allowed");
            }
            throw new SyntaxError(position, "continue  " + target + " not allowed");
        }
        this.semic();
        return this.factory.continueStatement(position, target);
    }

    public BreakStatement breakStatement() {
        Token position = this.consume(TokenType.BREAK);
        String target = null;
        switch (this.la(false)) {
            case SEMICOLON: 
            case CRNL: 
            case CR: 
            case NL: 
            case PARAGRAPH_SEPARATOR: 
            case LINE_SEPARATOR: 
            case RIGHT_BRACE: {
                break;
            }
            case IDENTIFIER: {
                target = this.consume(TokenType.IDENTIFIER).getText();
                break;
            }
            default: {
                throw new SyntaxError(this.laToken(false), "unexpected token: " + this.laToken(false).getText());
            }
        }
        if (!this.isValidBreak(target)) {
            if (target == null) {
                throw new SyntaxError(position, "break not allowed");
            }
            throw new SyntaxError(position, "break " + target + " not allowed");
        }
        this.semic();
        return this.factory.breakStatement(position, target);
    }

    public ReturnStatement returnStatement() {
        Token position = this.consume(TokenType.RETURN);
        if (!this.isValidReturn()) {
            throw new SyntaxError(position, "return not allowed");
        }
        Expression expr = null;
        switch (this.la(false)) {
            case SEMICOLON: 
            case CRNL: 
            case CR: 
            case NL: 
            case PARAGRAPH_SEPARATOR: 
            case LINE_SEPARATOR: 
            case RIGHT_BRACE: {
                return this.factory.returnStatement(position);
            }
        }
        expr = this.expression();
        ReturnStatement statement = this.factory.returnStatement(position, expr);
        this.semic();
        return statement;
    }

    public ThrowStatement throwStatement() {
        Token position = this.consume(TokenType.THROW);
        switch (this.la(false)) {
            case SEMICOLON: 
            case CRNL: 
            case CR: 
            case NL: 
            case PARAGRAPH_SEPARATOR: 
            case LINE_SEPARATOR: {
                throw new SyntaxError("unexpected line terminator after 'throw'");
            }
        }
        ThrowStatement statement = this.factory.throwStatement(position, this.expression());
        this.semic();
        return statement;
    }

    public WithStatement withStatement() {
        if (this.currentContext().isStrict()) {
            throw new SyntaxError("with() statement not allowed in strict-mode code");
        }
        Token position = this.consume(TokenType.WITH);
        this.consume(TokenType.LEFT_PAREN);
        Expression expr = this.expression();
        this.consume(TokenType.RIGHT_PAREN);
        Statement body = this.statement();
        return this.factory.withStatement(position, expr, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwitchStatement switchStatement() {
        try {
            this.pushContext(ParserContext.ContextType.SWITCH);
            Token position = this.consume(TokenType.SWITCH);
            this.consume(TokenType.LEFT_PAREN);
            Expression expr = this.expression();
            this.consume(TokenType.RIGHT_PAREN);
            this.consume(TokenType.LEFT_BRACE);
            ArrayList<CaseClause> clauses = new ArrayList<CaseClause>();
            while (this.la() == TokenType.CASE) {
                clauses.add(this.caseClause());
            }
            if (this.la() == TokenType.DEFAULT) {
                clauses.add(this.defaultClause());
            }
            while (this.la() == TokenType.CASE) {
                clauses.add(this.caseClause());
            }
            this.consume(TokenType.RIGHT_BRACE);
            SwitchStatement switchStatement = this.factory.switchStatement(position, expr, clauses);
            return switchStatement;
        }
        finally {
            this.popContext();
        }
    }

    protected CaseClause caseClause() {
        Token position = this.consume(TokenType.CASE);
        Expression expr = this.expression();
        this.consume(TokenType.COLON);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        block3: while (true) {
            TokenType t = this.la();
            switch (t) {
                case CASE: 
                case DEFAULT: 
                case RIGHT_BRACE: {
                    break block3;
                }
                default: {
                    statements.add(this.statement());
                    continue block3;
                }
            }
            break;
        }
        return this.factory.caseClause(position, expr, statements);
    }

    protected DefaultCaseClause defaultClause() {
        Token position = this.consume(TokenType.DEFAULT);
        this.consume(TokenType.COLON);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        block3: while (true) {
            TokenType t = this.la();
            switch (t) {
                case CASE: 
                case DEFAULT: 
                case RIGHT_BRACE: {
                    break block3;
                }
                default: {
                    statements.add(this.statement());
                    continue block3;
                }
            }
            break;
        }
        return this.factory.defaultClause(position, statements);
    }

    public TryStatement tryStatement() {
        Token position = this.consume(TokenType.TRY);
        BlockStatement block = this.block();
        CatchClause catchClause = null;
        BlockStatement finallyClause = null;
        if (this.la() == TokenType.CATCH) {
            catchClause = this.catchClause();
        }
        if (this.la() == TokenType.FINALLY) {
            finallyClause = this.finallyClause();
        }
        return this.factory.tryStatement(position, block, catchClause, finallyClause);
    }

    protected CatchClause catchClause() {
        Token position = this.consume(TokenType.CATCH);
        this.consume(TokenType.LEFT_PAREN);
        String ident = this.consume(TokenType.IDENTIFIER).getText();
        if (!this.isAssignableName(ident)) {
            throw new SyntaxError(position, "invalid identifier: " + ident);
        }
        this.consume(TokenType.RIGHT_PAREN);
        BlockStatement block = this.block();
        return this.factory.catchClause(position, ident, block);
    }

    protected BlockStatement finallyClause() {
        this.consume(TokenType.FINALLY);
        return this.block();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement labelledStatement() {
        String label = this.consume(TokenType.IDENTIFIER).getText();
        try {
            this.currentContext().addLabel(label);
            this.consume(TokenType.COLON);
            Statement statement = this.statement();
            statement.addLabel(label);
            Statement statement2 = statement;
            return statement2;
        }
        finally {
            this.currentContext().removeLabel(label);
        }
    }

    public DebuggerStatement debuggerStatement() {
        Token position = this.consume(TokenType.DEBUGGER);
        this.semic();
        return this.factory.debuggerStatement(position);
    }

    public Statement iterationStatement() {
        try {
            this.pushContext(ParserContext.ContextType.ITERATION);
            switch (this.la()) {
                case DO: {
                    DoWhileStatement doWhileStatement = this.doWhileStatement();
                    return doWhileStatement;
                }
                case WHILE: {
                    WhileStatement whileStatement = this.whileStatement();
                    return whileStatement;
                }
                case FOR: {
                    Statement statement = this.forStatement();
                    return statement;
                }
            }
            throw new SyntaxError("unexpected token: " + (Object)((Object)this.la()));
        }
        finally {
            this.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoWhileStatement doWhileStatement() {
        try {
            this.pushContext(ParserContext.ContextType.ITERATION);
            Token position = this.consume(TokenType.DO);
            Statement body = this.statement();
            this.consume(TokenType.WHILE);
            this.consume(TokenType.LEFT_PAREN);
            Expression expr = this.expression();
            this.consume(TokenType.RIGHT_PAREN);
            if (this.la() == TokenType.SEMICOLON) {
                this.consume(TokenType.SEMICOLON);
            }
            DoWhileStatement doWhileStatement = this.factory.doWhileStatement(position, body, expr);
            return doWhileStatement;
        }
        finally {
            this.popContext();
        }
    }

    public WhileStatement whileStatement() {
        Token position = this.consume(TokenType.WHILE);
        this.consume(TokenType.LEFT_PAREN);
        Expression expr = this.expression();
        this.consume(TokenType.RIGHT_PAREN);
        Statement body = this.statement();
        return this.factory.whileStatement(position, expr, body);
    }

    public Statement forStatement() {
        Token position = this.consume(TokenType.FOR);
        this.consume(TokenType.LEFT_PAREN);
        if (this.la() == TokenType.VAR) {
            this.consume(TokenType.VAR);
            List<VariableDeclaration> varDeclList = this.variableDeclarationList(true);
            if (this.la() == TokenType.IN) {
                if (varDeclList.size() != 1) {
                    throw new SyntaxError(varDeclList.get(1).getPosition(), "only one variable declaration is allowed");
                }
                this.consume(TokenType.IN);
                Expression rhs = this.expression();
                this.consume(TokenType.RIGHT_PAREN);
                Statement body = this.statement();
                return this.factory.forInStatement((Position)position, varDeclList.get(0), rhs, body);
            }
            this.consume(TokenType.SEMICOLON);
            Expression middle = null;
            Expression rhs = null;
            if (this.la() != TokenType.SEMICOLON) {
                middle = this.expression();
            }
            this.consume(TokenType.SEMICOLON);
            if (this.la() != TokenType.RIGHT_PAREN) {
                rhs = this.expression();
            }
            this.consume(TokenType.RIGHT_PAREN);
            Statement body = this.statement();
            return this.factory.forStatement((Position)position, varDeclList, middle, rhs, body);
        }
        Expression initializer = null;
        if (this.la() != TokenType.SEMICOLON) {
            initializer = this.expressionNoIn();
        }
        if (this.la() == TokenType.IN) {
            this.consume(TokenType.IN);
            Expression rhs = this.expression();
            this.consume(TokenType.RIGHT_PAREN);
            Statement body = this.statement();
            return this.factory.forInStatement((Position)position, initializer, rhs, body);
        }
        this.consume(TokenType.SEMICOLON);
        Expression middle = null;
        Expression rhs = null;
        if (this.la() != TokenType.SEMICOLON) {
            middle = this.expression();
        }
        this.consume(TokenType.SEMICOLON);
        if (this.la() != TokenType.RIGHT_PAREN) {
            rhs = this.expression();
        }
        this.consume(TokenType.RIGHT_PAREN);
        Statement body = this.statement();
        return this.factory.forStatement((Position)position, initializer, middle, rhs, body);
    }
}

