/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.js;

import java.util.LinkedList;
import java.util.ListIterator;
import org.dynjs.parser.js.Lexer;
import org.dynjs.parser.js.Token;
import org.dynjs.parser.js.TokenStream;
import org.dynjs.parser.js.TokenType;

public class TokenQueue
implements TokenStream {
    private Lexer lexer;
    private LinkedList<Token> queue = new LinkedList();

    public TokenQueue(Lexer lexer) {
        this.lexer = lexer;
    }

    @Override
    public Token peekToken() {
        return this.peekToken(true, 1);
    }

    @Override
    public TokenType peek() {
        return this.peek(true, 1);
    }

    @Override
    public Token peekToken(int pos) {
        return this.peekToken(true, pos);
    }

    @Override
    public TokenType peek(int pos) {
        return this.peek(true, pos);
    }

    @Override
    public Token consume() {
        return this.consume(true);
    }

    @Override
    public Token peekToken(boolean skipSkippable) {
        return this.peekToken(skipSkippable, 1);
    }

    @Override
    public TokenType peek(boolean skipSkippable) {
        return this.peek(skipSkippable, 1);
    }

    @Override
    public Token peekToken(boolean skipSkippable, int pos) {
        Token nextToken;
        int count = 0;
        for (Token each : this.queue) {
            if (skipSkippable && each.isSkippable() || ++count != pos) continue;
            return each;
        }
        do {
            nextToken = this.lexer.nextToken();
            this.queue.add(nextToken);
        } while (skipSkippable && nextToken.isSkippable() || ++count != pos);
        return nextToken;
    }

    @Override
    public TokenType peek(boolean skipSkippable, int pos) {
        return this.peekToken(skipSkippable, pos).getType();
    }

    @Override
    public Token consume(boolean skipSkippable) {
        Token nextToken;
        ListIterator iter = this.queue.listIterator();
        while (iter.hasNext()) {
            Token each = (Token)iter.next();
            iter.remove();
            if (skipSkippable && each.isSkippable()) continue;
            return each;
        }
        do {
            nextToken = this.lexer.nextToken();
        } while (skipSkippable && nextToken.isSkippable());
        return nextToken;
    }
}

