/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime;

import java.util.List;
import org.dynjs.parser.ast.FunctionDeclaration;
import org.dynjs.parser.ast.VariableDeclaration;
import org.dynjs.runtime.AbstractFunction;
import org.dynjs.runtime.Arguments;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.LexicalEnvironment;
import org.dynjs.runtime.Reference;

public class BoundFunction
extends AbstractFunction {
    private JSFunction target;
    private Object boundThis;
    private Object[] boundArgs;

    private static String[] figureBoundParameters(JSFunction fn, Object[] boundArgs) {
        String[] formalParams = fn.getFormalParameters();
        int numRemainingArgs = formalParams.length - boundArgs.length;
        if (numRemainingArgs <= 0) {
            return new String[0];
        }
        String[] remainingParams = new String[numRemainingArgs];
        for (int i = 0; i < numRemainingArgs; ++i) {
            remainingParams[i] = formalParams[i + boundArgs.length];
        }
        return remainingParams;
    }

    public BoundFunction(LexicalEnvironment scope, JSFunction target, Object boundThis, Object[] boundArgs) {
        super(scope, true, BoundFunction.figureBoundParameters(target, boundArgs));
        this.target = target;
        this.boundThis = boundThis;
        this.boundArgs = boundArgs;
    }

    @Override
    public Object call(ExecutionContext context) {
        int i;
        Arguments argsObj = (Arguments)context.resolve("arguments").getValue(context);
        int numExtraArgs = (Integer)argsObj.get(context, "length");
        Object[] args = new Object[this.boundArgs.length + numExtraArgs];
        for (i = 0; i < this.boundArgs.length; ++i) {
            args[i] = this.boundArgs[i];
        }
        for (i = 0; i < numExtraArgs; ++i) {
            Object v = argsObj.get(context, "" + i);
            if (v instanceof Reference) {
                v = ((Reference)v).getValue(context);
            }
            args[i + this.boundArgs.length] = v;
        }
        return context.call(this.target, this.boundThis, args);
    }

    @Override
    public boolean hasInstance(ExecutionContext context, Object v) {
        return this.target.hasInstance(context, v);
    }

    @Override
    public JSObject createNewObject(ExecutionContext context) {
        return this.target.createNewObject(context);
    }

    @Override
    public String getFileName() {
        return this.target.getFileName();
    }

    @Override
    public String getDebugContext() {
        return "bound-function:" + this.target.getDebugContext();
    }

    @Override
    public List<FunctionDeclaration> getFunctionDeclarations() {
        return this.target.getFunctionDeclarations();
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        return this.target.getVariableDeclarations();
    }
}

