/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.NameEnumerator;
import org.dynjs.runtime.PropertyDescriptor;
import org.dynjs.runtime.Types;

public class DynObject
implements JSObject,
Map<String, Object> {
    private String className;
    private JSObject prototype = null;
    private final Map<String, PropertyDescriptor> properties = new LinkedHashMap<String, PropertyDescriptor>();
    private boolean extensible = true;

    public DynObject(GlobalObject globalObject) {
        this.setClassName("Object");
        this.setExtensible(true);
        if (globalObject != null) {
            this.setPrototype(globalObject.getPrototypeFor("Object"));
        }
    }

    @Override
    public JSObject getPrototype() {
        return this.prototype;
    }

    @Override
    public void setPrototype(JSObject prototype) {
        this.prototype = prototype;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public boolean isExtensible() {
        return this.extensible;
    }

    @Override
    public void setExtensible(boolean extensible) {
        this.extensible = extensible;
    }

    @Override
    public Object get(ExecutionContext context, String name) {
        Object d = this.getProperty(context, name, false);
        if (d == Types.UNDEFINED) {
            return Types.UNDEFINED;
        }
        PropertyDescriptor desc = (PropertyDescriptor)d;
        if (desc.isDataDescriptor()) {
            Object value = desc.getValue();
            if (value == null) {
                value = Types.UNDEFINED;
            }
            return value;
        }
        Object g = desc.getGetter();
        if (g == null || g == Types.UNDEFINED) {
            return Types.UNDEFINED;
        }
        JSFunction getter = (JSFunction)g;
        return context.call(getter, this, new Object[0]);
    }

    @Override
    public Object getOwnProperty(ExecutionContext context, String name) {
        return this.getOwnProperty(context, name, true);
    }

    @Override
    public Object getOwnProperty(ExecutionContext context, String name, boolean dupe) {
        PropertyDescriptor x = this.properties.get(name);
        if (x == null) {
            return Types.UNDEFINED;
        }
        if (!dupe) {
            return x;
        }
        PropertyDescriptor dup = null;
        dup = x.isDataDescriptor() ? x.duplicate(0, 3, 5, 4) : x.duplicate(2, 1, 5, 4);
        return dup;
    }

    @Override
    public Object getProperty(ExecutionContext context, String name) {
        return this.getProperty(context, name, true);
    }

    @Override
    public Object getProperty(ExecutionContext context, String name, boolean dupe) {
        Object d = this.getOwnProperty(context, name, dupe);
        if (d != Types.UNDEFINED) {
            return d;
        }
        if (this.prototype == null) {
            return Types.UNDEFINED;
        }
        return this.prototype.getProperty(context, name, dupe);
    }

    @Override
    public boolean hasProperty(ExecutionContext context, String name) {
        return this.getProperty(context, name, false) != Types.UNDEFINED;
    }

    @Override
    public void put(ExecutionContext context, String name, Object value, boolean shouldThrow) {
        if (!this.canPut(context, name)) {
            if (shouldThrow) {
                throw new ThrowException(context, context.createTypeError("cannot put property '" + name + "'"));
            }
            return;
        }
        Object ownDesc = this.getOwnProperty(context, name, false);
        if (ownDesc != Types.UNDEFINED && ((PropertyDescriptor)ownDesc).isDataDescriptor()) {
            PropertyDescriptor newDesc = new PropertyDescriptor();
            newDesc.set((byte)0, value);
            this.defineOwnProperty(context, name, newDesc, shouldThrow);
            return;
        }
        Object desc = this.getProperty(context, name, false);
        if (desc != Types.UNDEFINED && ((PropertyDescriptor)desc).isAccessorDescriptor()) {
            JSFunction setter = (JSFunction)((PropertyDescriptor)desc).get((byte)1);
            context.call(setter, this, value);
        } else {
            PropertyDescriptor newDesc = new PropertyDescriptor();
            newDesc.set((byte)0, value);
            newDesc.set((byte)3, true);
            newDesc.set((byte)5, true);
            newDesc.set((byte)4, true);
            this.defineOwnProperty(context, name, newDesc, shouldThrow);
        }
    }

    @Override
    public boolean canPut(ExecutionContext context, String name) {
        Object d = this.getOwnProperty(context, name, false);
        if (d == Types.UNDEFINED && this.prototype != null) {
            d = this.prototype.getProperty(context, name, false);
        }
        if (d != Types.UNDEFINED) {
            PropertyDescriptor desc = (PropertyDescriptor)d;
            if (desc.isAccessorDescriptor()) {
                return desc.get((byte)1) != Types.UNDEFINED;
            }
            Object writable = desc.get((byte)3);
            if (writable == Types.UNDEFINED) {
                return true;
            }
            return (Boolean)writable;
        }
        return this.isExtensible();
    }

    @Override
    public boolean delete(ExecutionContext context, String name, boolean shouldThrow) {
        if (!this.properties.containsKey(name)) {
            return true;
        }
        Object d = this.getOwnProperty(context, name, false);
        if (d == Types.UNDEFINED) {
            return true;
        }
        PropertyDescriptor desc = (PropertyDescriptor)d;
        if (desc.get((byte)4) == Boolean.TRUE) {
            this.properties.remove(name);
            return true;
        }
        if (shouldThrow) {
            throw new ThrowException(context, context.createTypeError("cannot delete unconfigurable property '" + name + "'"));
        }
        return false;
    }

    @Override
    public Object defaultValue(ExecutionContext context, String hint) {
        if (hint == null) {
            hint = "Number";
        }
        if (hint.equals("String")) {
            Object result;
            Object result2;
            Object toString = this.get(context, "toString");
            if (toString instanceof JSFunction && ((result2 = context.call((JSFunction)toString, this, new Object[0])) instanceof String || result2 instanceof Number || result2 instanceof Boolean || result2 == Types.UNDEFINED || result2 == Types.NULL)) {
                return result2;
            }
            Object valueOf = this.get(context, "valueOf");
            if (valueOf instanceof JSFunction && ((result = context.call((JSFunction)valueOf, this, new Object[0])) instanceof String || result instanceof Number || result instanceof Boolean || result == Types.UNDEFINED || result == Types.NULL)) {
                return result;
            }
            throw new ThrowException(context, context.createTypeError("String coercion must return a primitive value"));
        }
        if (hint.equals("Number")) {
            Object result;
            Object result3;
            Object valueOf = this.get(context, "valueOf");
            if (valueOf instanceof JSFunction && ((result3 = context.call((JSFunction)valueOf, this, new Object[0])) instanceof String || result3 instanceof Number || result3 instanceof Boolean || result3 == Types.UNDEFINED || result3 == Types.NULL)) {
                return result3;
            }
            Object toString = this.get(context, "toString");
            if (toString instanceof JSFunction && ((result = context.call((JSFunction)toString, this, new Object[0])) instanceof String || result instanceof Number || result instanceof Boolean || result == Types.UNDEFINED || result == Types.NULL)) {
                return result;
            }
            throw new ThrowException(context, context.createTypeError("String coercion must return a primitive value"));
        }
        return null;
    }

    @Override
    public boolean defineOwnProperty(ExecutionContext context, String name, PropertyDescriptor desc, boolean shouldThrow) {
        Object c = this.getOwnProperty(context, name, false);
        if (c == Types.UNDEFINED) {
            if (!this.isExtensible()) {
                return this.reject(context, shouldThrow);
            }
            PropertyDescriptor newDesc = null;
            newDesc = desc.isGenericDescriptor() || desc.isDataDescriptor() ? desc.duplicateWithDefaults(0, 3, 5, 4) : desc.duplicateWithDefaults(2, 1, 5, 4);
            this.properties.put(name, newDesc);
            return true;
        }
        if (desc.isEmpty()) {
            return true;
        }
        PropertyDescriptor current = (PropertyDescriptor)c;
        if (current.hasConfigurable() && !current.isConfigurable()) {
            if (desc.hasConfigurable() && desc.isConfigurable()) {
                return this.reject(context, shouldThrow);
            }
            Object currentEnumerable = current.get((byte)5);
            Object descEnumerable = desc.get((byte)5);
            if (currentEnumerable != Types.UNDEFINED && descEnumerable != Types.UNDEFINED && currentEnumerable != descEnumerable) {
                return this.reject(context, shouldThrow);
            }
        }
        PropertyDescriptor newDesc = null;
        if (desc.isGenericDescriptor()) {
            newDesc = new PropertyDescriptor();
            newDesc.copyAll(current);
        } else if (current.isDataDescriptor() != desc.isDataDescriptor()) {
            if (!current.isConfigurable()) {
                return this.reject(context, shouldThrow);
            }
            newDesc = current.isDataDescriptor() ? PropertyDescriptor.newAccessorPropertyDescriptor(true) : PropertyDescriptor.newDataPropertyDescriptor(true);
        } else if (current.isDataDescriptor() && desc.isDataDescriptor()) {
            Object currentWritable;
            if (!current.isConfigurable() && (currentWritable = current.get((byte)3)) != Types.UNDEFINED && !current.isWritable()) {
                if (desc.isWritable()) {
                    return this.reject(context, shouldThrow);
                }
                Object newValue = desc.getValue();
                if (newValue != null && !Types.sameValue(current.getValue(), newValue)) {
                    return this.reject(context, shouldThrow);
                }
            }
            newDesc = PropertyDescriptor.newDataPropertyDescriptor(true);
            if (current.hasValue()) {
                newDesc.set((byte)0, current.get((byte)0));
            }
            if (current.hasWritable()) {
                newDesc.set((byte)3, current.get((byte)3));
            }
        } else if (current.isAccessorDescriptor() && desc.isAccessorDescriptor()) {
            if (!current.isConfigurable()) {
                Object newSetter = desc.getSetter();
                if (newSetter != null && !Types.sameValue(current.getSetter(), newSetter)) {
                    return this.reject(context, shouldThrow);
                }
                Object newGetter = desc.getGetter();
                if (newGetter != null && !Types.sameValue(current.getGetter(), newGetter)) {
                    return this.reject(context, shouldThrow);
                }
            }
            newDesc = PropertyDescriptor.newAccessorPropertyDescriptor(true);
            if (current.hasSet()) {
                newDesc.set((byte)1, current.get((byte)1));
            }
            if (current.hasGet()) {
                newDesc.set((byte)2, current.get((byte)2));
            }
        }
        if (current.hasConfigurable()) {
            newDesc.set((byte)4, current.get((byte)4));
        }
        if (current.hasEnumerable()) {
            newDesc.set((byte)5, current.get((byte)5));
        }
        newDesc.copyAll(desc);
        this.properties.put(name, newDesc);
        return true;
    }

    protected boolean reject(ExecutionContext context, boolean shouldThrow) {
        if (shouldThrow) {
            throw new ThrowException(context, context.createTypeError("unable to perform operation"));
        }
        return false;
    }

    @Override
    public NameEnumerator getOwnPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.properties.keySet()) {
            names.add(name);
        }
        return new NameEnumerator(names);
    }

    @Override
    public NameEnumerator getOwnEnumerablePropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.properties.keySet()) {
            PropertyDescriptor desc = this.properties.get(name);
            if (!desc.isEnumerable()) continue;
            names.add(name);
        }
        return new NameEnumerator(names);
    }

    @Override
    public NameEnumerator getAllEnumerablePropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.prototype != null) {
            names.addAll(this.prototype.getAllEnumerablePropertyNames().toList());
        }
        for (String name : this.properties.keySet()) {
            PropertyDescriptor desc = this.properties.get(name);
            if (desc.isEnumerable()) {
                names.add(name);
                continue;
            }
            names.remove(name);
        }
        return new NameEnumerator(names);
    }

    @Override
    public void defineNonEnumerableProperty(GlobalObject globalObject, String name, Object value) {
        PropertyDescriptor desc = new PropertyDescriptor();
        desc.set((byte)0, value);
        desc.set((byte)3, true);
        desc.set((byte)5, false);
        desc.set((byte)4, true);
        this.defineOwnProperty(null, name, desc, false);
    }

    @Override
    public void defineReadOnlyProperty(GlobalObject globalObject, String name, Object value) {
        PropertyDescriptor desc = new PropertyDescriptor();
        desc.set((byte)0, value);
        desc.set((byte)3, false);
        desc.set((byte)5, false);
        desc.set((byte)4, false);
        this.defineOwnProperty(null, name, desc, false);
    }

    @Override
    public int size() {
        return this.getAllEnumerablePropertyNames().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getAllEnumerablePropertyNames().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        Object desc = this.getProperty(null, key.toString(), false);
        return desc != Types.UNDEFINED;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Object get(Object key) {
        Object result = this.get(null, key.toString());
        if (result == Types.UNDEFINED) {
            return null;
        }
        return result;
    }

    @Override
    public Object put(String key, Object value) {
        Object oldValue = this.get(null, key.toString());
        this.put(null, key, value, false);
        return oldValue;
    }

    @Override
    public Object remove(Object key) {
        Object oldValue = this.get(null, key.toString());
        this.delete(null, key.toString(), false);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<String> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<Object> values() {
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return null;
    }

    protected class KeySet
    implements Set<String> {
        protected KeySet() {
        }

        @Override
        public int size() {
            return DynObject.this.getAllEnumerablePropertyNames().size();
        }

        @Override
        public boolean isEmpty() {
            return DynObject.this.getAllEnumerablePropertyNames().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return DynObject.this.hasProperty(null, o.toString());
        }

        @Override
        public Iterator<String> iterator() {
            return DynObject.this.getAllEnumerablePropertyNames().toList().iterator();
        }

        @Override
        public Object[] toArray() {
            return DynObject.this.getAllEnumerablePropertyNames().toList().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return DynObject.this.getAllEnumerablePropertyNames().toList().toArray(a);
        }

        @Override
        public boolean add(String e) {
            if (!DynObject.this.hasProperty(null, e)) {
                DynObject.this.put(e, (Object)Types.UNDEFINED);
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (DynObject.this.hasProperty(null, o.toString())) {
                DynObject.this.delete(null, o.toString(), false);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public void clear() {
        }

        public String toString() {
            return DynObject.this.getAllEnumerablePropertyNames().toList().toString();
        }
    }
}

