/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.dynjs.Clock;
import org.dynjs.Config;
import org.dynjs.compiler.JSCompiler;
import org.dynjs.exception.ThrowException;
import org.dynjs.parser.ast.FunctionDeclaration;
import org.dynjs.parser.ast.VariableDeclaration;
import org.dynjs.runtime.ArgGetter;
import org.dynjs.runtime.ArgSetter;
import org.dynjs.runtime.Arguments;
import org.dynjs.runtime.BasicBlock;
import org.dynjs.runtime.BlockManager;
import org.dynjs.runtime.Completion;
import org.dynjs.runtime.DeclarativeEnvironmentRecord;
import org.dynjs.runtime.DynJS;
import org.dynjs.runtime.DynObject;
import org.dynjs.runtime.DynamicClassLoader;
import org.dynjs.runtime.EnvironmentRecord;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.InitializationListener;
import org.dynjs.runtime.JSCode;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.JSProgram;
import org.dynjs.runtime.LexicalEnvironment;
import org.dynjs.runtime.ObjectEnvironmentRecord;
import org.dynjs.runtime.PropertyDescriptor;
import org.dynjs.runtime.Reference;
import org.dynjs.runtime.StackElement;
import org.dynjs.runtime.ThreadContextManager;
import org.dynjs.runtime.Types;

public class ExecutionContext {
    private ExecutionContext parent;
    private LexicalEnvironment lexicalEnvironment;
    private LexicalEnvironment variableEnvironment;
    private Object thisBinding;
    private boolean strict;
    private int lineNumber;
    private String fileName;
    private String debugContext = "<eval>";
    private Clock clock;
    private TimeZone timeZone;
    private Locale locale;
    private Object functionReference;

    public static ExecutionContext createGlobalExecutionContext(DynJS runtime) {
        LexicalEnvironment env = LexicalEnvironment.newGlobalEnvironment(runtime);
        ExecutionContext context = new ExecutionContext(null, env, env, env.getGlobalObject(), false);
        context.clock = runtime.getConfig().getClock();
        context.timeZone = runtime.getConfig().getTimeZone();
        context.locale = runtime.getConfig().getLocale();
        return context;
    }

    public static ExecutionContext createGlobalExecutionContext(DynJS runtime, InitializationListener listener) {
        ExecutionContext context = ExecutionContext.createEvalExecutionContext(runtime);
        listener.initialize(context);
        return context;
    }

    public static ExecutionContext createEvalExecutionContext(DynJS runtime) {
        return ExecutionContext.createGlobalExecutionContext(runtime);
    }

    public ExecutionContext(ExecutionContext parent, LexicalEnvironment lexicalEnvironment, LexicalEnvironment variableEnvironment, Object thisBinding, boolean strict) {
        this.parent = parent;
        this.lexicalEnvironment = lexicalEnvironment;
        this.variableEnvironment = variableEnvironment;
        this.thisBinding = thisBinding;
        this.strict = strict;
    }

    public Object getFunctionReference() {
        return this.functionReference;
    }

    public ExecutionContext getParent() {
        return this.parent;
    }

    public LexicalEnvironment getLexicalEnvironment() {
        return this.lexicalEnvironment;
    }

    public LexicalEnvironment getVariableEnvironment() {
        return this.variableEnvironment;
    }

    public Object getThisBinding() {
        return this.thisBinding;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public Clock getClock() {
        if (this.parent != null) {
            return this.parent.getClock();
        }
        return this.clock;
    }

    public TimeZone getTimeZone() {
        if (this.parent != null) {
            return this.parent.getTimeZone();
        }
        return this.timeZone;
    }

    public Locale getLocale() {
        if (this.parent != null) {
            return this.parent.getLocale();
        }
        return this.locale;
    }

    void setStrict(boolean strict) {
        this.strict = strict;
    }

    public Reference resolve(String name) {
        Reference result = this.lexicalEnvironment.getIdentifierReference(this, name, this.isStrict());
        return result;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    /*
     * Exception decompiling
     */
    public Completion execute(JSProgram program) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(JSProgram eval, boolean direct) {
        try {
            ExecutionContext evalContext = this.createEvalExecutionContext(eval, direct);
            ThreadContextManager.pushContext(evalContext);
            Completion result = eval.execute(evalContext);
            Object object = result.value;
            return object;
        }
        finally {
            ThreadContextManager.popContext();
        }
    }

    public Object call(JSFunction function, Object self, Object ... args) {
        return this.call((Object)null, function, self, args);
    }

    public Object call(Object functionReference, JSFunction function, Object self, Object ... args) {
        return this.internalCall(functionReference, function, self, args);
    }

    public Object construct(Reference reference, Object ... args) {
        Object value = reference.getValue(this);
        if (value instanceof JSFunction) {
            return this.construct(reference, (JSFunction)value, args);
        }
        return null;
    }

    public Object construct(JSFunction function, Object ... args) {
        if (!function.isConstructor()) {
            throw new ThrowException(this, this.createTypeError("not a constructor"));
        }
        JSObject obj = function.createNewObject(this);
        Object p = function.get(this, "prototype");
        if (p != Types.UNDEFINED && p instanceof JSObject) {
            obj.setPrototype((JSObject)p);
        } else {
            JSObject defaultObjectProto = this.getPrototypeFor("Object");
            obj.setPrototype(defaultObjectProto);
        }
        Object result = this.internalCall(null, function, obj, args);
        if (result instanceof JSObject) {
            return (JSObject)result;
        }
        return obj;
    }

    public Object internalCall(Object functionReference, JSFunction function, Object self, Object ... args) {
        try {
            ExecutionContext fnContext = this.createFunctionExecutionContext(functionReference, function, self, args);
            ThreadContextManager.pushContext(fnContext);
            try {
                Object value = function.call(fnContext);
                if (value == null) {
                    Types.Null nullVal = Types.NULL;
                    return nullVal;
                }
                Object object = value;
                return object;
            }
            catch (ThrowException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ThrowException(fnContext, e);
            }
        }
        finally {
            ThreadContextManager.popContext();
        }
    }

    public ExecutionContext createEvalExecutionContext(JSProgram eval, boolean direct) {
        ExecutionContext context = null;
        Object evalThisBinding = null;
        LexicalEnvironment evalLexEnv = null;
        LexicalEnvironment evalVarEnv = null;
        if (!direct) {
            evalThisBinding = this.getGlobalObject();
            evalLexEnv = LexicalEnvironment.newGlobalEnvironment(this.getGlobalObject());
            evalVarEnv = LexicalEnvironment.newGlobalEnvironment(this.getGlobalObject());
        } else {
            evalThisBinding = this.thisBinding;
            evalLexEnv = this.getLexicalEnvironment();
            evalVarEnv = this.getVariableEnvironment();
        }
        if (eval.isStrict()) {
            LexicalEnvironment strictVarEnv;
            evalLexEnv = strictVarEnv = LexicalEnvironment.newDeclarativeEnvironment(this.getLexicalEnvironment());
            evalVarEnv = strictVarEnv;
        }
        context = new ExecutionContext(this, evalLexEnv, evalVarEnv, evalThisBinding, eval.isStrict());
        context.performFunctionDeclarationBindings(eval, true);
        context.performVariableDeclarationBindings(eval, true);
        context.fileName = eval.getFileName();
        return context;
    }

    public ExecutionContext createFunctionExecutionContext(Object functionReference, JSFunction function, Object thisArg, Object ... arguments) {
        Object thisBinding = null;
        thisBinding = function.isStrict() ? thisArg : (thisArg == null || thisArg == Types.NULL || thisArg == Types.UNDEFINED ? this.getLexicalEnvironment().getGlobalObject() : (!(thisArg instanceof JSObject) ? Types.toThisObject(this, thisArg) : thisArg));
        LexicalEnvironment scope = function.getScope();
        LexicalEnvironment localEnv = LexicalEnvironment.newDeclarativeEnvironment(scope);
        ExecutionContext context = new ExecutionContext(this, localEnv, localEnv, thisBinding, function.isStrict());
        context.performDeclarationBindingInstantiation(function, arguments);
        context.fileName = function.getFileName();
        context.debugContext = function.getDebugContext();
        context.functionReference = functionReference;
        return context;
    }

    public Completion executeCatch(BasicBlock block, String identifier, Object thrown) {
        LexicalEnvironment oldEnv = this.lexicalEnvironment;
        LexicalEnvironment catchEnv = LexicalEnvironment.newDeclarativeEnvironment(oldEnv);
        catchEnv.getRecord().createMutableBinding(this, identifier, false);
        catchEnv.getRecord().setMutableBinding(this, identifier, thrown, false);
        try {
            this.lexicalEnvironment = catchEnv;
            Completion completion = block.call(this);
            return completion;
        }
        catch (ThrowException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ThrowException(this, t);
        }
        finally {
            this.lexicalEnvironment = oldEnv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Completion executeWith(JSObject withObj, BasicBlock block) {
        LexicalEnvironment oldEnv = this.lexicalEnvironment;
        LexicalEnvironment withEnv = LexicalEnvironment.newObjectEnvironment(withObj, true, oldEnv);
        try {
            this.lexicalEnvironment = withEnv;
            Completion completion = block.call(this);
            return completion;
        }
        finally {
            this.lexicalEnvironment = oldEnv;
        }
    }

    private void performDeclarationBindingInstantiation(JSProgram program) {
        this.performFunctionDeclarationBindings(program, false);
        this.performVariableDeclarationBindings(program, false);
    }

    private void performDeclarationBindingInstantiation(JSFunction function, Object[] arguments) {
        String[] names = function.getFormalParameters();
        Object v = null;
        DeclarativeEnvironmentRecord env = (DeclarativeEnvironmentRecord)this.variableEnvironment.getRecord();
        for (int i = 0; i < names.length; ++i) {
            v = i + 1 > arguments.length ? Types.UNDEFINED : arguments[i];
            if (!env.hasBinding(this, names[i])) {
                env.createMutableBinding(this, names[i], false);
            }
            env.setMutableBinding(this, names[i], v, function.isStrict());
        }
        this.performFunctionDeclarationBindings(function, false);
        if (!env.hasBinding(this, "arguments")) {
            Arguments argsObj = this.createArgumentsObject(function, arguments);
            if (function.isStrict()) {
                env.createImmutableBinding("arguments");
                env.initializeImmutableBinding("arguments", argsObj);
            } else {
                env.createMutableBinding(this, "arguments", false);
                env.setMutableBinding(this, "arguments", argsObj, false);
            }
        }
        this.performVariableDeclarationBindings(function, false);
    }

    private Arguments createArgumentsObject(JSFunction function, Object[] arguments) {
        Arguments obj = new Arguments(this.getGlobalObject());
        PropertyDescriptor desc = new PropertyDescriptor();
        desc.set((byte)0, arguments.length);
        desc.set((byte)3, true);
        desc.set((byte)5, false);
        desc.set((byte)4, true);
        obj.defineOwnProperty(this, "length", desc, false);
        String[] names = function.getFormalParameters();
        DynObject map = new DynObject(this.getGlobalObject());
        ArrayList<String> mappedNames = new ArrayList<String>();
        LexicalEnvironment env = this.getVariableEnvironment();
        for (int i = 0; i < arguments.length; ++i) {
            Object val = arguments[i];
            desc = new PropertyDescriptor();
            desc.set((byte)0, val);
            desc.set((byte)3, true);
            desc.set((byte)5, true);
            desc.set((byte)4, true);
            obj.defineOwnProperty(this, "" + i, desc, false);
            if (i >= names.length || function.isStrict()) continue;
            String name = names[i];
            if (i >= names.length || mappedNames.contains(name)) continue;
            mappedNames.add(name);
            desc = new PropertyDescriptor();
            desc.set((byte)1, new ArgSetter(env, name));
            desc.set((byte)2, new ArgGetter(env, name));
            desc.set((byte)4, true);
            map.defineOwnProperty(this, "" + i, desc, false);
        }
        if (!mappedNames.isEmpty()) {
            obj.setParameterMap(map);
        }
        if (function.isStrict()) {
            JSFunction thrower = (JSFunction)this.getGlobalObject().get(this, "__throwTypeError");
            PropertyDescriptor callerDesc = new PropertyDescriptor();
            callerDesc.set((byte)2, thrower);
            callerDesc.set((byte)1, thrower);
            callerDesc.set((byte)5, false);
            callerDesc.set((byte)4, false);
            obj.defineOwnProperty(this, "caller", callerDesc, false);
            PropertyDescriptor calleeDesc = new PropertyDescriptor();
            calleeDesc.set((byte)2, thrower);
            calleeDesc.set((byte)1, thrower);
            calleeDesc.set((byte)5, false);
            calleeDesc.set((byte)4, false);
            obj.defineOwnProperty(this, "callee", calleeDesc, false);
        } else {
            PropertyDescriptor calleeDesc = new PropertyDescriptor();
            calleeDesc.set((byte)0, function);
            calleeDesc.set((byte)3, true);
            calleeDesc.set((byte)5, false);
            calleeDesc.set((byte)4, true);
            obj.defineOwnProperty(this, "callee", calleeDesc, false);
        }
        return obj;
    }

    private void performFunctionDeclarationBindings(JSCode code, boolean configurableBindings) {
        List<FunctionDeclaration> decls = code.getFunctionDeclarations();
        EnvironmentRecord env = this.variableEnvironment.getRecord();
        for (FunctionDeclaration each : decls) {
            String identifier = each.getIdentifier();
            if (!env.hasBinding(this, identifier)) {
                env.createMutableBinding(this, identifier, configurableBindings);
            } else if (env.isGlobal()) {
                JSObject globalObject = ((ObjectEnvironmentRecord)env).getBindingObject();
                PropertyDescriptor existingProp = (PropertyDescriptor)globalObject.getProperty(this, identifier, false);
                if (existingProp.isConfigurable()) {
                    PropertyDescriptor newProp = new PropertyDescriptor();
                    newProp.set((byte)0, Types.UNDEFINED);
                    newProp.set((byte)3, true);
                    newProp.set((byte)5, true);
                    newProp.set((byte)4, configurableBindings);
                    globalObject.defineOwnProperty(this, identifier, newProp, true);
                } else if (existingProp.isAccessorDescriptor() || !existingProp.isWritable() && !existingProp.isEnumerable()) {
                    throw new ThrowException(this, this.createTypeError("unable to bind function '" + identifier + "'"));
                }
            }
            JSFunction function = this.getCompiler().compileFunction(this, identifier, each.getFormalParameters(), each.getBlock(), each.isStrict());
            function.setDebugContext(identifier);
            env.setMutableBinding(this, identifier, function, code.isStrict());
        }
    }

    private void performVariableDeclarationBindings(JSCode code, boolean configurableBindings) {
        List<VariableDeclaration> decls = code.getVariableDeclarations();
        EnvironmentRecord env = this.variableEnvironment.getRecord();
        for (VariableDeclaration decl : decls) {
            String identifier = decl.getIdentifier();
            if (env.hasBinding(this, identifier)) continue;
            env.createMutableBinding(this, identifier, configurableBindings);
            env.setMutableBinding(this, identifier, Types.UNDEFINED, code.isStrict());
        }
    }

    public Config getConfig() {
        return this.getGlobalObject().getConfig();
    }

    public GlobalObject getGlobalObject() {
        return this.lexicalEnvironment.getGlobalObject();
    }

    public JSCompiler getCompiler() {
        return this.getGlobalObject().getCompiler();
    }

    public BlockManager getBlockManager() {
        return this.getGlobalObject().getBlockManager();
    }

    public Reference createPropertyReference(Object base, String propertyName) {
        return new Reference(this.getGlobalObject(), propertyName, base, this.isStrict());
    }

    public BlockManager.Entry retrieveBlockEntry(int statementNumber) {
        return this.lexicalEnvironment.getGlobalObject().retrieveBlockEntry(statementNumber);
    }

    public JSObject createTypeError(String message) {
        return this.createError("TypeError", message);
    }

    public JSObject createReferenceError(String message) {
        return this.createError("ReferenceError", message);
    }

    public JSObject createRangeError(String message) {
        return this.createError("RangeError", message);
    }

    public JSObject createSyntaxError(String message) {
        return this.createError("SyntaxError", message);
    }

    public JSObject createUriError(String message) {
        return this.createError("URIError", message);
    }

    public JSObject createError(String type, String message) {
        JSFunction func = (JSFunction)this.getGlobalObject().get(this, type);
        JSObject err = null;
        err = message == null ? (JSObject)this.construct(func, new Object[0]) : (JSObject)this.construct(func, message);
        return err;
    }

    public void collectStackElements(List<StackElement> elements) {
        elements.add(new StackElement(this.fileName, this.lineNumber, this.debugContext));
        if (this.parent != null) {
            this.parent.collectStackElements(elements);
        }
    }

    public JSObject getPrototypeFor(String type) {
        return this.getGlobalObject().getPrototypeFor(type);
    }

    public String toString() {
        return "ExecutionContext: " + System.identityHashCode(this) + "; parent=" + this.parent;
    }

    public DynamicClassLoader getClassLoader() {
        return this.getConfig().getClassLoader();
    }
}

