/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime;

import org.dynjs.runtime.DeclarativeEnvironmentRecord;
import org.dynjs.runtime.DynJS;
import org.dynjs.runtime.EnvironmentRecord;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.ObjectEnvironmentRecord;
import org.dynjs.runtime.Reference;
import org.dynjs.runtime.Types;

public class LexicalEnvironment {
    private LexicalEnvironment outer;
    private EnvironmentRecord record;
    private GlobalObject globalObject;

    public static LexicalEnvironment newDeclarativeEnvironment(LexicalEnvironment outer) {
        return new LexicalEnvironment(new DeclarativeEnvironmentRecord(), outer);
    }

    public static LexicalEnvironment newObjectEnvironment(JSObject object, boolean provideThis, LexicalEnvironment outer) {
        return new LexicalEnvironment(new ObjectEnvironmentRecord(object, provideThis), outer);
    }

    public static LexicalEnvironment newGlobalEnvironment(DynJS runtime) {
        return new LexicalEnvironment(new ObjectEnvironmentRecord(GlobalObject.newGlobalObject(runtime), false), null);
    }

    public static LexicalEnvironment newGlobalEnvironment(GlobalObject globalObject) {
        return new LexicalEnvironment(new ObjectEnvironmentRecord(globalObject, false), null);
    }

    private LexicalEnvironment(EnvironmentRecord record, LexicalEnvironment outer) {
        this.record = record;
        this.outer = outer;
        this.globalObject = this.outer == null ? (GlobalObject)((ObjectEnvironmentRecord)this.record).getBindingObject() : this.outer.getGlobalObject();
    }

    public EnvironmentRecord getRecord() {
        return this.record;
    }

    public LexicalEnvironment getOuter() {
        return this.outer;
    }

    public GlobalObject getGlobalObject() {
        return this.globalObject;
    }

    public Reference getIdentifierReference(ExecutionContext context, String name, boolean strict) {
        boolean exists = this.record.hasBinding(context, name);
        if (exists) {
            return new Reference(this.getGlobalObject(), name, this.record, strict);
        }
        if (this.outer == null) {
            return new Reference(this.getGlobalObject(), name, Types.UNDEFINED, strict);
        }
        return this.outer.getIdentifierReference(context, name, strict);
    }
}

