/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime;

import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.EnvironmentRecord;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.PropertyDescriptor;
import org.dynjs.runtime.Types;

public class ObjectEnvironmentRecord
implements EnvironmentRecord {
    private JSObject object;
    private boolean provideThis;

    public ObjectEnvironmentRecord(JSObject object, boolean provideThis) {
        this.object = object;
        this.provideThis = provideThis;
    }

    public JSObject getBindingObject() {
        return this.object;
    }

    public String toString() {
        return "[ObjectEnvironmentRecord: object=" + this.object + "]";
    }

    @Override
    public boolean hasBinding(ExecutionContext context, String name) {
        return this.object.hasProperty(context, name);
    }

    @Override
    public void createMutableBinding(ExecutionContext context, String name, boolean configValue) {
        PropertyDescriptor desc = new PropertyDescriptor();
        desc.set((byte)0, Types.UNDEFINED);
        desc.set((byte)3, true);
        desc.set((byte)5, true);
        desc.set((byte)4, configValue);
        this.object.defineOwnProperty(context, name, desc, true);
    }

    @Override
    public void setMutableBinding(ExecutionContext context, String name, Object value, boolean strict) {
        this.object.put(context, name, value, strict);
    }

    @Override
    public Object getBindingValue(ExecutionContext context, String name, boolean strict) {
        Object d = this.object.getProperty(context, name, false);
        if (d == Types.UNDEFINED) {
            if (strict) {
                throw new ThrowException(context, context.createReferenceError(name + " is not defined"));
            }
            return Types.UNDEFINED;
        }
        PropertyDescriptor desc = (PropertyDescriptor)d;
        return desc.getValue();
    }

    @Override
    public boolean deleteBinding(ExecutionContext context, String name) {
        return this.object.delete(context, name, false);
    }

    @Override
    public Object implicitThisValue() {
        if (this.provideThis) {
            return this.object;
        }
        return Types.UNDEFINED;
    }

    @Override
    public boolean isGlobal() {
        return this.object instanceof GlobalObject;
    }
}

