/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime;

import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.DynObject;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.Types;

public class PropertyDescriptor {
    private static final Object defaultValue = Types.UNDEFINED;
    private static final Object defaultSet = Types.UNDEFINED;
    private static final Object defaultGet = Types.UNDEFINED;
    private static final boolean defaultWritable = false;
    private static final boolean defaultConfigurable = false;
    private static final boolean defaultEnumerable = false;
    private Object value;
    private Object set;
    private Object get;
    private byte writable = (byte)-1;
    private byte configurable = (byte)-1;
    private byte enumerable = (byte)-1;
    private byte initialized = (byte)-1;
    private static final byte UNDEFINED_FLAG = -1;
    private static final byte FALSE_FLAG = 0;
    private static final byte TRUE_FLAG = 1;

    public static PropertyDescriptor newAccessorPropertyDescriptor(boolean withDefaults) {
        PropertyDescriptor desc = new PropertyDescriptor();
        if (withDefaults) {
            desc.set((byte)1, defaultSet);
            desc.set((byte)2, defaultGet);
            desc.set((byte)4, false);
            desc.set((byte)5, false);
        }
        return desc;
    }

    public static PropertyDescriptor newDataPropertyDescriptor(boolean withDefaults) {
        PropertyDescriptor desc = new PropertyDescriptor();
        if (withDefaults) {
            desc.set((byte)0, defaultValue);
            desc.set((byte)3, false);
            desc.set((byte)4, false);
            desc.set((byte)5, false);
        }
        return desc;
    }

    public static PropertyDescriptor newPropertyDescriptorForObjectInitializer(Object value) {
        return PropertyDescriptor.newPropertyDescriptorForObjectInitializer(null, value);
    }

    public static PropertyDescriptor newPropertyDescriptorForObjectInitializer(String name, Object value) {
        if (name != null && value instanceof JSFunction) {
            ((JSFunction)value).setDebugContext("Object." + name);
        }
        PropertyDescriptor d = new PropertyDescriptor();
        d.value = value;
        d.setWritable(true);
        d.setConfigurable(true);
        d.setEnumerable(true);
        return d;
    }

    public static PropertyDescriptor newPropertyDescriptorForObjectInitializerGet(Object orig, String name, JSFunction value) {
        value.setDebugContext("Object.get " + name);
        PropertyDescriptor d = null;
        d = orig == Types.UNDEFINED ? new PropertyDescriptor() : (PropertyDescriptor)orig;
        d.get = value;
        d.setConfigurable(true);
        d.setEnumerable(true);
        return d;
    }

    public static PropertyDescriptor newPropertyDescriptorForObjectInitializerSet(Object orig, String name, JSFunction value) {
        value.setDebugContext("Object.set " + name);
        PropertyDescriptor d = null;
        d = orig == Types.UNDEFINED ? new PropertyDescriptor() : (PropertyDescriptor)orig;
        d.set = value;
        d.setConfigurable(true);
        d.setEnumerable(true);
        return d;
    }

    public String toString() {
        return "[PropertyDescriptor value=" + this.value + "; writable=" + this.isWritable() + "; enumerable=" + this.isEnumerable() + "; configurable=" + this.isConfigurable() + "; setter=" + this.set + "; getter=" + this.get + "]";
    }

    private Boolean getFlag(byte name) {
        switch (name) {
            case 3: {
                return PropertyDescriptor.byteToBoolean(this.writable);
            }
            case 4: {
                return PropertyDescriptor.byteToBoolean(this.configurable);
            }
            case 5: {
                return PropertyDescriptor.byteToBoolean(this.enumerable);
            }
            case 6: {
                return PropertyDescriptor.byteToBoolean(this.initialized);
            }
        }
        return null;
    }

    private void setFlag(byte name, Object value) {
        switch (name) {
            case 3: {
                this.writable = PropertyDescriptor.objectToByte(value);
                break;
            }
            case 4: {
                this.configurable = PropertyDescriptor.objectToByte(value);
                break;
            }
            case 5: {
                this.enumerable = PropertyDescriptor.objectToByte(value);
                break;
            }
            case 6: {
                this.initialized = PropertyDescriptor.objectToByte(value);
            }
        }
    }

    private static Boolean byteToBoolean(byte value) {
        return value == -1 ? null : Boolean.valueOf(value == 1);
    }

    private static byte objectToByte(Object value) {
        return value == Types.UNDEFINED ? (byte)-1 : ((Boolean)value != false ? (byte)1 : 0);
    }

    public boolean isWritable() {
        Boolean writable = this.getFlag((byte)3);
        if (writable == null) {
            return false;
        }
        return writable;
    }

    public boolean hasWritable() {
        return this.getFlag((byte)3) != null;
    }

    public void setWritable(boolean writable) {
        this.setFlag((byte)3, writable);
    }

    public boolean isConfigurable() {
        Boolean configurable = this.getFlag((byte)4);
        if (configurable == null) {
            return false;
        }
        return configurable;
    }

    public boolean hasConfigurable() {
        return this.getFlag((byte)4) != null;
    }

    public void setConfigurable(boolean configurable) {
        this.setFlag((byte)4, configurable);
    }

    public boolean isEnumerable() {
        Boolean enumerable = this.getFlag((byte)5);
        if (enumerable == null) {
            return false;
        }
        return enumerable;
    }

    public void setEnumerable(boolean enumerable) {
        this.setFlag((byte)5, enumerable);
    }

    public boolean hasEnumerable() {
        return this.getFlag((byte)5) != null;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public Object getSetter() {
        return this.set;
    }

    public void setSetter(JSFunction setter) {
        this.set = setter;
    }

    public boolean hasSet() {
        return this.set != null;
    }

    public Object getGetter() {
        return this.get;
    }

    public void setGetter(JSFunction getter) {
        this.get = getter;
    }

    public boolean hasGet() {
        return this.get != null;
    }

    public boolean isEmpty() {
        return this.value == null && this.set == null && this.get == null && this.getFlag((byte)3) == null && this.getFlag((byte)4) == null && this.getFlag((byte)5) == null;
    }

    public void set(byte name, Object value) {
        switch (name) {
            case 0: {
                this.value = value;
                break;
            }
            case 1: {
                this.set = value;
                break;
            }
            case 2: {
                this.get = value;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.setFlag(name, value);
            }
        }
    }

    public Object get(byte name) {
        switch (name) {
            case 0: {
                return this.value != null ? this.value : Types.UNDEFINED;
            }
            case 1: {
                return this.set != null ? this.set : Types.UNDEFINED;
            }
            case 2: {
                return this.get != null ? this.get : Types.UNDEFINED;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                Boolean value = this.getFlag(name);
                return value != null ? value : Types.UNDEFINED;
            }
        }
        return Types.UNDEFINED;
    }

    public boolean isPresent(byte name) {
        switch (name) {
            case 0: {
                return this.value != null;
            }
            case 1: {
                return this.set != null;
            }
            case 2: {
                return this.get != null;
            }
            case 3: 
            case 4: 
            case 5: {
                return this.getFlag(name) != null;
            }
        }
        return false;
    }

    public Object getWithDefault(byte name) {
        Object v = this.get(name);
        if (v == null) {
            switch (name) {
                case 0: {
                    return defaultValue;
                }
                case 1: {
                    return defaultSet;
                }
                case 2: {
                    return defaultGet;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    return false;
                }
            }
        }
        return v;
    }

    public PropertyDescriptor duplicate(byte ... attributes) {
        PropertyDescriptor d = new PropertyDescriptor();
        block6: for (int i = 0; i < attributes.length; ++i) {
            switch (attributes[i]) {
                case 0: {
                    d.value = this.value;
                    continue block6;
                }
                case 1: {
                    d.set = this.set;
                    continue block6;
                }
                case 2: {
                    d.get = this.get;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 5: {
                    d.setFlag(attributes[i], this.getFlag(attributes[i]));
                }
            }
        }
        return d;
    }

    public PropertyDescriptor duplicateWithDefaults(byte ... attributes) {
        PropertyDescriptor d = new PropertyDescriptor();
        block6: for (int i = 0; i < attributes.length; ++i) {
            switch (attributes[i]) {
                case 0: {
                    d.value = this.value != null ? this.value : Types.UNDEFINED;
                    continue block6;
                }
                case 1: {
                    d.set = this.set != null ? this.set : Types.UNDEFINED;
                    continue block6;
                }
                case 2: {
                    d.get = this.get != null ? this.get : Types.UNDEFINED;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 5: {
                    Boolean thisValue = this.getFlag(attributes[i]);
                    d.setFlag(attributes[i], thisValue != null ? thisValue : false);
                }
            }
        }
        return d;
    }

    public void copyAll(PropertyDescriptor from) {
        if (from.value != null) {
            this.value = from.value;
        }
        if (from.set != null) {
            this.set = from.set;
        }
        if (from.get != null) {
            this.get = from.get;
        }
        if (from.getFlag((byte)3) != null) {
            this.setFlag((byte)3, from.getFlag((byte)3));
        }
        if (from.getFlag((byte)4) != null) {
            this.setFlag((byte)4, from.getFlag((byte)4));
        }
        if (from.getFlag((byte)5) != null) {
            this.setFlag((byte)5, from.getFlag((byte)5));
        }
    }

    public boolean isAccessorDescriptor() {
        return this.get != null || this.set != null;
    }

    public boolean isDataDescriptor() {
        return this.value != null || this.getFlag((byte)3) != null;
    }

    public boolean isGenericDescriptor() {
        return !this.isAccessorDescriptor() && !this.isDataDescriptor();
    }

    public static Object fromPropertyDescriptor(ExecutionContext context, Object d) {
        if (d == Types.UNDEFINED) {
            return Types.UNDEFINED;
        }
        PropertyDescriptor desc = (PropertyDescriptor)d;
        DynObject obj = new DynObject(context.getGlobalObject());
        if (desc.isDataDescriptor()) {
            PropertyDescriptor valueDesc = new PropertyDescriptor();
            valueDesc.set((byte)0, desc.get((byte)0));
            valueDesc.set((byte)3, true);
            valueDesc.set((byte)4, true);
            valueDesc.set((byte)5, true);
            obj.defineOwnProperty(context, "value", valueDesc, false);
            PropertyDescriptor writableDesc = new PropertyDescriptor();
            writableDesc.set((byte)0, desc.get((byte)3));
            writableDesc.set((byte)3, true);
            writableDesc.set((byte)4, true);
            writableDesc.set((byte)5, true);
            obj.defineOwnProperty(context, "writable", writableDesc, false);
        } else {
            PropertyDescriptor getDesc = new PropertyDescriptor();
            getDesc.set((byte)0, desc.get((byte)2));
            getDesc.set((byte)3, true);
            getDesc.set((byte)4, true);
            getDesc.set((byte)5, true);
            obj.defineOwnProperty(context, "get", getDesc, false);
            PropertyDescriptor setDesc = new PropertyDescriptor();
            setDesc.set((byte)0, desc.get((byte)1));
            setDesc.set((byte)3, true);
            setDesc.set((byte)4, true);
            setDesc.set((byte)5, true);
            obj.defineOwnProperty(context, "set", setDesc, false);
        }
        PropertyDescriptor enumerableDesc = new PropertyDescriptor();
        enumerableDesc.set((byte)0, desc.get((byte)5));
        enumerableDesc.set((byte)3, true);
        enumerableDesc.set((byte)4, true);
        enumerableDesc.set((byte)5, true);
        obj.defineOwnProperty(context, "enumerable", enumerableDesc, false);
        PropertyDescriptor configurableDesc = new PropertyDescriptor();
        configurableDesc.set((byte)0, desc.get((byte)4));
        configurableDesc.set((byte)3, true);
        configurableDesc.set((byte)4, true);
        configurableDesc.set((byte)5, true);
        obj.defineOwnProperty(context, "configurable", configurableDesc, false);
        return obj;
    }

    public static PropertyDescriptor toPropertyDescriptor(ExecutionContext context, Object o) {
        if (!(o instanceof JSObject)) {
            throw new ThrowException(context, context.createTypeError("attribtues must be an object"));
        }
        JSObject obj = (JSObject)o;
        PropertyDescriptor d = new PropertyDescriptor();
        if (obj.hasProperty(context, "enumerable")) {
            d.set((byte)5, Types.toBoolean(obj.get(context, "enumerable")));
        }
        if (obj.hasProperty(context, "configurable")) {
            d.set((byte)4, Types.toBoolean(obj.get(context, "configurable")));
        }
        if (obj.hasProperty(context, "value")) {
            d.set((byte)0, obj.get(context, "value"));
        }
        if (obj.hasProperty(context, "writable")) {
            d.set((byte)3, Types.toBoolean(obj.get(context, "writable")));
        }
        if (obj.hasProperty(context, "get")) {
            Object getter = obj.get(context, "get");
            if (!Types.isCallable(getter) && getter != Types.UNDEFINED) {
                throw new ThrowException(context, context.createTypeError("get must be callable"));
            }
            d.set((byte)2, getter);
        }
        if (obj.hasProperty(context, "set")) {
            Object setter = obj.get(context, "set");
            if (!Types.isCallable(setter) && setter != Types.UNDEFINED) {
                throw new ThrowException(context, context.createTypeError("set must be callable"));
            }
            d.set((byte)1, setter);
        }
        if (!(d.get((byte)2) == Types.UNDEFINED && d.get((byte)1) == Types.UNDEFINED || d.get((byte)3) == Types.UNDEFINED && d.get((byte)0) == Types.UNDEFINED)) {
            throw new ThrowException(context, context.createTypeError("may not be both a data property and an accessor property"));
        }
        return d;
    }

    public static final class Names {
        public static final byte VALUE = 0;
        public static final byte SET = 1;
        public static final byte GET = 2;
        public static final byte WRITABLE = 3;
        public static final byte CONFIGURABLE = 4;
        public static final byte ENUMERABLE = 5;
        public static final byte INITIALIZED = 6;
    }
}

