/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime;

import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.EnvironmentRecord;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.PropertyDescriptor;
import org.dynjs.runtime.Types;

public class Reference {
    private JSObject globalObject;
    private Object base;
    private String referencedName;
    private boolean strict;

    public Reference(JSObject globalObject, String referencedName, Object base, boolean strict) {
        this.globalObject = globalObject;
        this.referencedName = referencedName;
        this.base = base;
        this.strict = strict;
    }

    public Object getBase() {
        return this.base;
    }

    public String getReferencedName() {
        return this.referencedName;
    }

    public boolean isStrictReference() {
        return this.strict;
    }

    public boolean hasPrimitiveBase() {
        return this.base instanceof String || this.base instanceof Number || this.base instanceof Boolean;
    }

    public boolean isPropertyReference() {
        return !(this.base instanceof EnvironmentRecord);
    }

    public boolean isUnresolvableReference() {
        return this.base == Types.UNDEFINED;
    }

    public Object getValue(ExecutionContext context) {
        Object value = null;
        if (this.isUnresolvableReference()) {
            throw new ThrowException(context, context.createReferenceError(this.referencedName + " is not defined"));
        }
        value = this.isPropertyReference() ? (!this.hasPrimitiveBase() ? ((JSObject)this.base).get(context, this.referencedName) : this.primitiveGet(context, Types.toObject(context, this.base), this.referencedName)) : ((EnvironmentRecord)this.base).getBindingValue(context, this.referencedName, this.strict);
        return value;
    }

    protected Object primitiveGet(ExecutionContext context, JSObject o, String name) {
        Object d = o.getProperty(context, name, false);
        if (d == Types.UNDEFINED) {
            return Types.UNDEFINED;
        }
        PropertyDescriptor desc = (PropertyDescriptor)d;
        if (desc.isDataDescriptor()) {
            Object value = desc.getValue();
            if (value == null) {
                value = Types.UNDEFINED;
            }
            return value;
        }
        Object getter = desc.get((byte)2);
        if (getter == Types.UNDEFINED) {
            return Types.UNDEFINED;
        }
        return context.call((JSFunction)getter, o, new Object[0]);
    }

    public void putValue(ExecutionContext context, Object value) {
        if (this.isUnresolvableReference()) {
            if (this.isStrictReference()) {
                throw new ThrowException(context, context.createReferenceError(this.referencedName + " is not defined"));
            }
            this.globalObject.put(context, this.referencedName, value, false);
        } else if (this.isPropertyReference()) {
            if (!this.hasPrimitiveBase()) {
                ((JSObject)this.base).put(context, this.referencedName, value, this.strict);
            }
        } else {
            ((EnvironmentRecord)this.base).setMutableBinding(context, this.referencedName, value, this.strict);
        }
    }

    public boolean isValidForPrePostIncrementDecrement() {
        return !this.isStrictReference() || !(this.getBase() instanceof EnvironmentRecord) || !this.referencedName.equals("eval") && !this.referencedName.equals("arguments");
    }

    public String toString() {
        return "[Reference: name=" + this.referencedName + "; base=" + this.base + " (" + this.base.getClass().getName() + ")]";
    }
}

