/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime;

import java.util.ArrayList;
import java.util.List;
import org.dynjs.runtime.AbstractNativeFunction;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.StackElement;
import org.dynjs.runtime.Types;

public class StackGetter
extends AbstractNativeFunction {
    private List<StackElement> stack;

    public StackGetter(ExecutionContext context) {
        super(context.getGlobalObject(), new String[0]);
        ArrayList<StackElement> stack = new ArrayList<StackElement>();
        context.collectStackElements(stack);
        this.stack = stack;
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        JSObject jsObject = (JSObject)self;
        String errorName = null;
        if (jsObject.hasProperty(context, "name")) {
            errorName = Types.toString(context, jsObject.get(context, "name"));
        }
        String message = null;
        if (jsObject.hasProperty(context, "message")) {
            message = Types.toString(context, jsObject.get(context, "message"));
        }
        StringBuilder buf = new StringBuilder();
        if (errorName == null) {
            buf.append("<unknown>");
        } else {
            buf.append(errorName);
        }
        if (message != null && !message.equals("")) {
            buf.append(": " + message);
        }
        buf.append("\n");
        for (StackElement each : this.stack) {
            buf.append("  at " + each + "\n");
        }
        return buf.toString();
    }

    @Override
    public void setFileName() {
        this.filename = "<internal>";
    }

    @Override
    public void setupDebugContext() {
        this.setDebugContext("<stack-getter>");
    }
}

