/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.JSCallable;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.PrimitiveDynObject;
import org.dynjs.runtime.Reference;
import org.dynjs.runtime.builtins.types.bool.DynBoolean;
import org.dynjs.runtime.builtins.types.number.DynNumber;
import org.dynjs.runtime.builtins.types.string.DynString;

public class Types {
    public static final Undefined UNDEFINED = new Undefined();
    public static final Null NULL = new Null();
    static final Pattern decimalDigitPattern = Pattern.compile(".*[0-9].*");
    private static Pattern EXP_PATTERN = Pattern.compile("^(.*)e([+-])([0-9]+)$");
    private static final Pattern POSSIBLE_EXP_REGEXP = Pattern.compile("^(.*?)(\\.\\d*)*E([+-])?(\\d+)");

    public static void checkObjectCoercible(ExecutionContext context, Object o) {
        if (o == UNDEFINED) {
            throw new ThrowException(context, context.createTypeError("undefined cannot be coerced to an object"));
        }
        if (o == NULL) {
            throw new ThrowException(context, context.createTypeError("null cannot be coerced to an object"));
        }
    }

    public static void checkObjectCoercible(ExecutionContext context, Object o, String debug) {
        if (o == UNDEFINED) {
            throw new ThrowException(context, context.createTypeError("undefined cannot be coerced to an object: " + debug));
        }
        if (o == NULL) {
            throw new ThrowException(context, context.createTypeError("null cannot be coerced to an object: " + debug));
        }
    }

    public static boolean sameValue(Object left, Object right) {
        if (left.getClass() != right.getClass()) {
            return false;
        }
        if (left == UNDEFINED) {
            return true;
        }
        if (left == NULL) {
            return true;
        }
        return left.equals(right);
    }

    public static JSObject toObject(ExecutionContext context, Object o) {
        if (o instanceof JSObject) {
            return (JSObject)o;
        }
        if (o instanceof String) {
            return new DynString(context.getGlobalObject(), (String)o);
        }
        if (o instanceof Number) {
            return new DynNumber(context.getGlobalObject(), (Number)o);
        }
        if (o instanceof Boolean) {
            return new DynBoolean(context.getGlobalObject(), (Boolean)o);
        }
        if (o == UNDEFINED) {
            throw new ThrowException(context, context.createTypeError("undefined cannot be converted to an object"));
        }
        if (o == NULL) {
            throw new ThrowException(context, context.createTypeError("null cannot be converted to an object"));
        }
        return new PrimitiveDynObject(context.getGlobalObject(), o);
    }

    public static Object toThisObject(ExecutionContext context, Object o) {
        if (o instanceof JSObject) {
            return (JSObject)o;
        }
        if (o instanceof String) {
            return new DynString(context.getGlobalObject(), (String)o);
        }
        if (o instanceof Number) {
            return new DynNumber(context.getGlobalObject(), (Number)o);
        }
        if (o instanceof Boolean) {
            return new DynBoolean(context.getGlobalObject(), (Boolean)o);
        }
        if (o == UNDEFINED) {
            throw new ThrowException(context, context.createTypeError("undefined cannot be converted to an object"));
        }
        if (o == NULL) {
            throw new ThrowException(context, context.createTypeError("null cannot be converted to an object"));
        }
        return o;
    }

    public static Object toPrimitive(ExecutionContext context, Object o) {
        return Types.toPrimitive(context, o, null);
    }

    public static Object toPrimitive(ExecutionContext context, Object o, String preferredType) {
        if (o instanceof JSObject) {
            return ((JSObject)o).defaultValue(context, preferredType);
        }
        return o;
    }

    public static Number toNumber(ExecutionContext context, Object o) {
        if (o instanceof Number) {
            return (Number)o;
        }
        if (o instanceof JSObject) {
            return Types.toNumber(context, Types.toPrimitive(context, o, "Number"));
        }
        if (o == UNDEFINED) {
            return Double.NaN;
        }
        if (o == NULL) {
            return 0L;
        }
        if (o instanceof Boolean) {
            if (o == Boolean.TRUE) {
                return 1L;
            }
            return 0L;
        }
        Number n = Types.stringToNumber(o.toString());
        return n;
    }

    public static String trimString(String value) {
        int st;
        int len = value.length();
        char[] val = value.toCharArray();
        for (st = 0; st < len && Types.isWhitespace(val[st]); ++st) {
        }
        while (st < len && Types.isWhitespace(val[len - 1])) {
            --len;
        }
        String result = null;
        result = st > 0 || len < value.length() ? value.substring(st, len) : value;
        return result;
    }

    public static String trimNumericString(String value) {
        char[] val = value.toCharArray();
        StringBuilder newStr = new StringBuilder();
        for (int i = 0; i < val.length; ++i) {
            if (Types.isWhitespace(val[i])) continue;
            newStr.append(val[i]);
        }
        return newStr.toString().trim();
    }

    public static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\u00a0': 
            case '\u1680': 
            case '\u180e': 
            case '\u2000': 
            case '\u2001': 
            case '\u2002': 
            case '\u2003': 
            case '\u2004': 
            case '\u2005': 
            case '\u2006': 
            case '\u2007': 
            case '\u2008': 
            case '\u2009': 
            case '\u200a': 
            case '\u2028': 
            case '\u2029': 
            case '\u202f': 
            case '\u205f': 
            case '\u3000': 
            case '\ufeff': {
                return true;
            }
        }
        return false;
    }

    public static Number stringToNumber(String str) {
        if ((str = Types.trimNumericString(str)).equals("")) {
            return 0L;
        }
        if (str.equals("-0")) {
            return -0.0;
        }
        if (str.equals("Infinity") || str.equals("+Infinity")) {
            return Math.pow(10.0, 10000.0);
        }
        if (str.equals("-Infinity")) {
            return -Math.pow(10.0, 10000.0);
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            return Long.decode(str);
        }
        if (!decimalDigitPattern.matcher(str).matches()) {
            return Double.NaN;
        }
        if (str.indexOf("e") > 0 || str.indexOf("E") > 0) {
            str = str.indexOf(".") >= 0 ? str.replaceFirst("[eE]", "E") : str.replaceFirst("[eE]", ".0E");
        }
        try {
            if (str.indexOf(".") >= 0) {
                return Double.valueOf(str);
            }
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static Boolean toBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o == UNDEFINED || o == NULL) {
            return false;
        }
        if (o instanceof Double) {
            if (((Double)o).isNaN() || (Double)o == 0.0) {
                return false;
            }
            return true;
        }
        if (o instanceof Number) {
            if (((Number)o).intValue() == 0) {
                return false;
            }
            return true;
        }
        if (o instanceof String) {
            return ((String)o).length() != 0;
        }
        if (o instanceof JSObject) {
            return true;
        }
        return true;
    }

    public static Long toInteger(ExecutionContext context, Object o) {
        Number number = Types.toNumber(context, o);
        if (number instanceof Double && ((Double)number).isNaN()) {
            return 0L;
        }
        return number.longValue();
    }

    public static Long toUint16(ExecutionContext context, Object o) {
        Number n = Types.toNumber(context, o);
        if (n instanceof Double && (((Double)n).isInfinite() || ((Double)n).isNaN())) {
            return 0L;
        }
        long posInt = (long)((double)Types.sign(n) * Math.floor(Math.abs(n.longValue())));
        return Types.modulo(posInt, 65536L);
    }

    protected static int sign(Number n) {
        if (n.doubleValue() < 0.0) {
            return -1;
        }
        return 1;
    }

    public static Long toUint32(ExecutionContext context, Object o) {
        Number n = Types.toNumber(context, o);
        if (n instanceof Double && (((Double)n).isInfinite() || ((Double)n).isNaN() || (Double)n == 0.0)) {
            return 0L;
        }
        double d = n.doubleValue();
        long posInt = (long)((double)Types.sign(d) * Math.floor(Math.abs(d)));
        long int32bit = Types.modulo(posInt, 0x100000000L);
        return int32bit;
    }

    public static long modulo(long a, long b) {
        return (a % b + b) % b;
    }

    public static Long toInt32(ExecutionContext context, Object o) {
        Number number = Types.toNumber(context, o);
        if (Double.isInfinite(number.doubleValue()) || Double.isNaN(number.doubleValue())) {
            return 0L;
        }
        double doubleNum = number.doubleValue();
        long posInt = (long)((double)Types.sign(doubleNum) * Math.floor(Math.abs(doubleNum)));
        long int32bit = Types.modulo(posInt, 0x100000000L);
        if (int32bit >= 0x80000000L) {
            int32bit -= 0x100000000L;
        }
        return int32bit;
    }

    public static boolean isCallable(Object o) {
        return o instanceof JSCallable;
    }

    public static boolean isSparse(ExecutionContext context, JSObject o) {
        if (!o.hasProperty(context, "length")) {
            return false;
        }
        long len = Types.toUint32(context, o.get(context, "length"));
        for (long i = 0L; i < len; ++i) {
            if (o.getOwnProperty(context, "" + i, false) != UNDEFINED) continue;
            return true;
        }
        return false;
    }

    public static Object getValue(ExecutionContext context, Object o) {
        if (o instanceof Reference) {
            return ((Reference)o).getValue(context);
        }
        return o;
    }

    public static String toString(ExecutionContext context, Object o) {
        if (o == UNDEFINED) {
            return "undefined";
        }
        if (o == NULL || o == null) {
            return "null";
        }
        if (o instanceof JSObject) {
            return Types.toString(context, Types.toPrimitive(context, o, "String"));
        }
        if (o instanceof Number) {
            String result;
            Matcher matcher;
            Double dbl;
            if (((Number)o).doubleValue() == 0.0) {
                return "0";
            }
            if (o instanceof Double && (dbl = (Double)o) == (double)((long)dbl.doubleValue())) {
                o = dbl.longValue();
            }
            if ((matcher = EXP_PATTERN.matcher(result = Types.rewritePossiblyExponentialValue(o.toString()))).matches()) {
                int expValue = Integer.parseInt(matcher.group(3));
                if (matcher.group(2).equals("+")) {
                    if (expValue <= 20) {
                        String digits = matcher.group(1).replace(".", "");
                        StringBuilder newResult = new StringBuilder();
                        int offset = 0;
                        if (digits.startsWith("-")) {
                            newResult.append("-");
                            offset = 1;
                        }
                        for (int i = offset; i <= expValue; ++i) {
                            if (i >= digits.length()) {
                                newResult.append("0");
                                continue;
                            }
                            newResult.append(digits.charAt(i));
                        }
                        if (newResult.length() < digits.length()) {
                            newResult.append(".");
                            newResult.append(digits.substring(newResult.length() - 1));
                        }
                        result = newResult.toString();
                    }
                } else if (expValue <= 6) {
                    StringBuilder newResult = new StringBuilder().append("0.");
                    for (int i = 0; i < expValue - 1; ++i) {
                        newResult.append(0);
                    }
                    String digits = matcher.group(1).replace(".", "");
                    if (digits.startsWith("-")) {
                        newResult.append(digits.substring(1));
                        newResult.insert(0, "-");
                    } else {
                        newResult.append(digits);
                    }
                    result = newResult.toString();
                }
            }
            return result;
        }
        return o.toString();
    }

    public static String typeof(ExecutionContext context, Object o) {
        Object val = o;
        if (o instanceof Reference) {
            Reference r = (Reference)o;
            if (r.isUnresolvableReference()) {
                return "undefined";
            }
            val = Types.getValue(context, o);
        }
        return Types.type(val);
    }

    public static Object compareRelational(ExecutionContext context, Object x, Object y, boolean leftFirst) {
        Object px = null;
        Object py = null;
        if (leftFirst) {
            px = Types.toPrimitive(context, x, "Number");
            py = Types.toPrimitive(context, y, "Number");
        } else {
            py = Types.toPrimitive(context, y, "Number");
            px = Types.toPrimitive(context, x, "Number");
        }
        if (px instanceof String && py instanceof String) {
            String sx = (String)px;
            String sy = (String)py;
            if (sx.compareTo(sy) < 0) {
                return true;
            }
            return false;
        }
        Number nx = Types.toNumber(context, px);
        Number ny = Types.toNumber(context, py);
        if (Double.isNaN(nx.doubleValue()) || Double.isNaN(ny.doubleValue())) {
            return UNDEFINED;
        }
        if (nx.equals(ny)) {
            return false;
        }
        if (nx.doubleValue() == Double.POSITIVE_INFINITY) {
            return false;
        }
        if (ny.doubleValue() == Double.POSITIVE_INFINITY) {
            return true;
        }
        if (ny.doubleValue() == Double.NEGATIVE_INFINITY) {
            return false;
        }
        if (nx.doubleValue() == Double.NEGATIVE_INFINITY) {
            return true;
        }
        if (nx.doubleValue() < ny.doubleValue()) {
            return true;
        }
        return false;
    }

    public static boolean compareEquality(ExecutionContext context, Object lhs, Object rhs) {
        if (lhs.getClass().equals(rhs.getClass()) || lhs instanceof Number && rhs instanceof Number) {
            if (lhs == UNDEFINED) {
                return true;
            }
            if (lhs == NULL) {
                return true;
            }
            if (lhs instanceof Number) {
                if (lhs instanceof Double && ((Double)lhs).isNaN()) {
                    return false;
                }
                if (rhs instanceof Double && ((Double)rhs).isNaN()) {
                    return false;
                }
                return ((Number)lhs).doubleValue() == ((Number)rhs).doubleValue();
            }
            if (lhs instanceof String || lhs instanceof Boolean) {
                return lhs.equals(rhs);
            }
            if (lhs == rhs) {
                return true;
            }
        }
        if (lhs == UNDEFINED && rhs == NULL) {
            return true;
        }
        if (lhs == NULL && rhs == UNDEFINED) {
            return true;
        }
        if (lhs instanceof Number && rhs instanceof String) {
            return Types.compareEquality(context, lhs, Types.toNumber(context, rhs));
        }
        if (lhs instanceof String && rhs instanceof Number) {
            return Types.compareEquality(context, Types.toNumber(context, lhs), rhs);
        }
        if (lhs instanceof Boolean) {
            return Types.compareEquality(context, Types.toNumber(context, lhs), rhs);
        }
        if (rhs instanceof Boolean) {
            return Types.compareEquality(context, lhs, Types.toNumber(context, rhs));
        }
        if ((lhs instanceof String || lhs instanceof Number) && rhs instanceof JSObject) {
            return Types.compareEquality(context, lhs, Types.toPrimitive(context, rhs));
        }
        if (lhs instanceof JSObject && (rhs instanceof String || rhs instanceof Number)) {
            return Types.compareEquality(context, Types.toPrimitive(context, lhs), rhs);
        }
        return false;
    }

    public static boolean compareStrictEquality(ExecutionContext context, Object lhs, Object rhs) {
        if (!(lhs.getClass().equals(rhs.getClass()) || lhs instanceof Number && rhs instanceof Number)) {
            return false;
        }
        if (lhs == UNDEFINED) {
            return true;
        }
        if (lhs == NULL) {
            return true;
        }
        if (lhs instanceof Number) {
            if (((Number)lhs).doubleValue() == Double.NaN) {
                return false;
            }
            if (rhs instanceof Number && ((Number)rhs).doubleValue() == Double.NaN) {
                return false;
            }
            return ((Number)lhs).doubleValue() == ((Number)rhs).doubleValue();
        }
        if (lhs instanceof String || lhs instanceof Boolean) {
            return lhs.equals(rhs);
        }
        return lhs == rhs;
    }

    public static String type(Object o) {
        if (o == UNDEFINED) {
            return "undefined";
        }
        if (o == NULL) {
            return "object";
        }
        if (o instanceof Boolean) {
            return "boolean";
        }
        if (o instanceof Number) {
            return "number";
        }
        if (o instanceof JSFunction) {
            return "function";
        }
        if (o instanceof JSObject) {
            return "object";
        }
        if (o instanceof String) {
            return "string";
        }
        return o.getClass().getName();
    }

    public static String rewritePossiblyExponentialValue(String value) {
        Matcher matcher = POSSIBLE_EXP_REGEXP.matcher(value);
        if (matcher.matches()) {
            String decimal = matcher.group(1);
            String fraction = matcher.group(2);
            String sign = matcher.group(3);
            String exponent = matcher.group(4);
            if (fraction == null || ".0".equals(fraction)) {
                fraction = "";
            }
            if (sign == null) {
                sign = "+";
            }
            return decimal + fraction + "e" + sign + exponent;
        }
        return value;
    }

    public static Number parseLongOrDouble(String text, int radix) {
        Double dbl = radix == 10 ? Double.valueOf(text) : Double.valueOf(new BigInteger(text, radix).doubleValue());
        if (dbl == (double)((long)dbl.doubleValue())) {
            return dbl.longValue();
        }
        return dbl;
    }

    public static class Null {
        private Null() {
        }

        public String typeof() {
            return "object";
        }

        public String toString() {
            return "null";
        }
    }

    public static class Undefined {
        private Undefined() {
        }

        public String typeof() {
            return "undefined";
        }

        public String toString() {
            return "undefined";
        }
    }
}

