/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins;

import org.dynjs.runtime.AbstractNativeFunction;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.Types;

public class Escape
extends AbstractNativeFunction {
    private static final String ACCEPT = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@*_+-./";

    public Escape(GlobalObject globalObject) {
        super(globalObject, "string");
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        String string = Types.toString(context, args[0]);
        StringBuilder result = new StringBuilder();
        for (int k = 0; k < string.length(); ++k) {
            char c = string.charAt(k);
            if (ACCEPT.indexOf(c) >= 0) {
                result.append(c);
                continue;
            }
            result.append("%").append(Integer.toHexString(c));
        }
        return result.toString();
    }

    @Override
    public void setFileName() {
        this.filename = "org/dynjs/runtime/builtins/Escape.java";
    }

    @Override
    public void setupDebugContext() {
        this.debugContext = "<native function: escape>";
    }
}

