/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins;

import org.dynjs.runtime.AbstractNonConstructorFunction;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.Types;

public class ParseFloat
extends AbstractNonConstructorFunction {
    public ParseFloat(GlobalObject globalObject) {
        super(globalObject, "f");
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        char c;
        int i;
        String text = Types.toString(context, args[0]);
        if (text.equals("")) {
            return Double.NaN;
        }
        int len = text.length();
        int firstNonWhitespace = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = text.charAt(i2);
            if (Types.isWhitespace(c2)) continue;
            firstNonWhitespace = i2;
            break;
        }
        if (text.substring(firstNonWhitespace).startsWith("Infinity") || text.substring(firstNonWhitespace).startsWith("+Infinity")) {
            return Double.POSITIVE_INFINITY;
        }
        if (text.substring(firstNonWhitespace).startsWith("-Infinity")) {
            return Double.NEGATIVE_INFINITY;
        }
        int digitSearchStart = firstNonWhitespace;
        int lastDigit = firstNonWhitespace;
        if (text.charAt(firstNonWhitespace) == '-' || text.charAt(firstNonWhitespace) == '+') {
            ++digitSearchStart;
        }
        boolean dotSeen = false;
        for (i = digitSearchStart; i < len; ++i) {
            c = text.charAt(i);
            if (c >= '0' && c <= '9') {
                lastDigit = i;
                continue;
            }
            if (dotSeen || c != '.') break;
            lastDigit = i;
            dotSeen = true;
        }
        if (text.length() > lastDigit + 1 && (text.charAt(digitSearchStart = lastDigit + 1) == 'e' || text.charAt(digitSearchStart) == 'E')) {
            if (text.charAt(++digitSearchStart) == '-' || text.charAt(digitSearchStart) == '+') {
                ++digitSearchStart;
            }
            i = digitSearchStart;
            while (i < len && (c = text.charAt(i)) >= '0' && c <= '9') {
                lastDigit = i++;
            }
        }
        text = text.substring(firstNonWhitespace, lastDigit + 1);
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    @Override
    public void setFileName() {
        this.filename = "org/dynjs/runtime/builtins/ParseFloat.java";
    }

    @Override
    public void setupDebugContext() {
        this.debugContext = "<native function: parseFloat>";
    }
}

