/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins.types;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.dynjs.compiler.JSCompiler;
import org.dynjs.exception.ThrowException;
import org.dynjs.parser.ast.FunctionDescriptor;
import org.dynjs.parser.js.ASTFactory;
import org.dynjs.parser.js.CircularCharBuffer;
import org.dynjs.parser.js.Lexer;
import org.dynjs.parser.js.Parser;
import org.dynjs.parser.js.ParserException;
import org.dynjs.parser.js.TokenQueue;
import org.dynjs.runtime.AbstractNativeFunction;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.Types;
import org.dynjs.runtime.builtins.types.AbstractBuiltinType;
import org.dynjs.runtime.builtins.types.function.prototype.Apply;
import org.dynjs.runtime.builtins.types.function.prototype.Bind;
import org.dynjs.runtime.builtins.types.function.prototype.Call;
import org.dynjs.runtime.builtins.types.function.prototype.ToString;

public class BuiltinFunction
extends AbstractBuiltinType {
    public BuiltinFunction(GlobalObject globalObject) {
        super(globalObject, "args");
        AbstractNativeFunction proto = new AbstractNativeFunction(globalObject, false, new String[0]){

            @Override
            public Object call(ExecutionContext context, Object self, Object ... args) {
                return Types.UNDEFINED;
            }
        };
        this.setPrototypeProperty(proto);
    }

    @Override
    public void initialize(GlobalObject globalObject, JSObject proto) {
        proto.setPrototype(globalObject.getPrototypeFor("Object"));
        this.defineNonEnumerableProperty(proto, "constructor", (Object)this);
        this.defineNonEnumerableProperty(proto, "toString", (Object)new ToString(globalObject));
        this.defineNonEnumerableProperty(proto, "apply", (Object)new Apply(globalObject));
        this.defineNonEnumerableProperty(proto, "call", (Object)new Call(globalObject));
        this.defineNonEnumerableProperty(proto, "bind", (Object)new Bind(globalObject));
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        int numArgs = args.length;
        String body = "";
        StringBuilder formalParams = new StringBuilder();
        boolean first = true;
        HashSet<String> seenParams = new HashSet<String>();
        boolean duplicateFormalParams = false;
        for (int i = 0; i < numArgs - 1; ++i) {
            String paramStr = Types.toString(context, args[i]);
            StringTokenizer paramTokens = new StringTokenizer(paramStr, ",");
            while (paramTokens.hasMoreTokens()) {
                String param;
                if (!first) {
                    formalParams.append(",");
                }
                if (seenParams.contains(param = paramTokens.nextToken().trim())) {
                    duplicateFormalParams = true;
                }
                seenParams.add(param);
                formalParams.append(param);
                first = false;
            }
        }
        if (numArgs > 0) {
            body = Types.toString(context, args[numArgs - 1]);
        }
        StringBuilder code = new StringBuilder();
        code.append("function(" + formalParams.toString() + "){\n");
        code.append(body);
        code.append("}");
        try {
            FunctionDescriptor descriptor = this.parseFunction(context, code.toString());
            JSCompiler compiler = context.getGlobalObject().getCompiler();
            JSFunction function = compiler.compileFunction(context, descriptor.getIdentifier(), descriptor.getFormalParameterNames(), descriptor.getBlock(), descriptor.isStrict());
            if (function.isStrict()) {
                if (duplicateFormalParams) {
                    throw new ThrowException(context, context.createSyntaxError("duplicate formal parameters in function definition"));
                }
                if (seenParams.contains("eval")) {
                    throw new ThrowException(context, context.createSyntaxError("formal parameter 'eval' not allowed in function definition in strict-mode"));
                }
            }
            function.setPrototype(this.getPrototype());
            return function;
        }
        catch (ParserException e) {
            throw new ThrowException(context, context.createSyntaxError(e.getMessage()));
        }
        catch (IOException e) {
            throw new ThrowException(context, context.createSyntaxError(e.getMessage()));
        }
    }

    public FunctionDescriptor parseFunction(ExecutionContext context, String code) throws IOException {
        StringReader in = new StringReader(code);
        CircularCharBuffer charStream = new CircularCharBuffer(in);
        Lexer lexer = new Lexer(charStream);
        TokenQueue tokenStream = new TokenQueue(lexer);
        Parser parser = new Parser(context, new ASTFactory(), tokenStream);
        return parser.functionDescriptor();
    }

    @Override
    public void setFileName() {
        this.filename = "org/dynjs/runtime/builtins/types/BuiltinFunction.java";
    }

    @Override
    public void setupDebugContext() {
        this.debugContext = "<native function: Function>";
    }
}

