/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins.types.array.prototype;

import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.AbstractNonConstructorFunction;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.Types;

public class ToLocaleString
extends AbstractNonConstructorFunction {
    public ToLocaleString(GlobalObject globalObject) {
        super(globalObject, new String[0]);
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        JSObject o = Types.toObject(context, self);
        long len = Types.toUint32(context, o.get(context, "length"));
        if (len == 0L) {
            return "";
        }
        String separator = ",";
        StringBuilder str = new StringBuilder();
        boolean first = true;
        for (long i = 0L; i < len; ++i) {
            if (!first) {
                str.append(separator);
            }
            first = false;
            Object element = o.get(context, "" + i);
            if (element == Types.UNDEFINED || element == Types.NULL) continue;
            JSObject jsElement = Types.toObject(context, element);
            Object toLocaleString = jsElement.get(context, "toLocaleString");
            if (!Types.isCallable(toLocaleString)) {
                throw new ThrowException(context, context.createTypeError("toLocaleString must be callable"));
            }
            str.append(context.call((JSFunction)toLocaleString, jsElement, new Object[0]));
        }
        return str.toString();
    }

    @Override
    public void setFileName() {
        this.filename = "org/dynjs/runtime/builtins/types/array/prototype/ToLocaleString.java";
    }

    @Override
    public void setupDebugContext() {
        this.debugContext = "<native function: toLocaleString>";
    }
}

