/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins.types.date.prototype;

import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.Types;
import org.dynjs.runtime.builtins.types.date.AbstractDateFunction;
import org.dynjs.runtime.builtins.types.date.DynDate;

public class SetYear
extends AbstractDateFunction {
    public SetYear(GlobalObject globalObject) {
        super(globalObject, "year", "month", "date");
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        if (!(self instanceof DynDate)) {
            throw new ThrowException(context, context.createTypeError("setYear(...) may only be used with Dates"));
        }
        DynDate dateObj = (DynDate)self;
        long t = SetYear.localTime(context, dateObj.getTimeValue());
        Number y = Types.toNumber(context, args[0]);
        if (Double.isNaN(y.doubleValue())) {
            dateObj.setTimeValue(Double.NaN);
            return Double.NaN;
        }
        long year = y.longValue() + 1900L;
        Number m = null;
        m = args[1] != Types.UNDEFINED ? (Number)Types.toNumber(context, args[1]) : (Number)SetYear.monthFromTime(t);
        Number dt = null;
        dt = args[1] != Types.UNDEFINED ? (Number)Types.toNumber(context, args[2]) : (Number)SetYear.dateFromTime(t);
        Number newDate = SetYear.makeDate(context, SetYear.makeDay(context, year, m, dt), SetYear.timeWithinDay(t));
        Number u = SetYear.timeClip(context, SetYear.utc(context, newDate));
        dateObj.setTimeValue(u);
        return u;
    }

    @Override
    public void setFileName() {
        this.filename = "org/dynjs/runtime/builtins/types/date/prototype/SetYear.java";
    }

    @Override
    public void setupDebugContext() {
        this.debugContext = "<native function: setYear>";
    }
}

