/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins.types.function.prototype;

import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.AbstractNonConstructorFunction;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.Types;

public class Apply
extends AbstractNonConstructorFunction {
    public Apply(GlobalObject globalObject) {
        super(globalObject, "thisArg", "argArray");
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        if (!(self instanceof JSFunction)) {
            throw new ThrowException(context, context.createTypeError("Function.apply() only allowed on callable objects"));
        }
        Object thisArg = args[0];
        Object argArray = args[1];
        if (argArray == Types.UNDEFINED || argArray == Types.NULL) {
            return context.call((JSFunction)self, thisArg, new Object[0]);
        }
        if (!(argArray instanceof JSObject)) {
            throw new ThrowException(context, context.createTypeError("argArray must be an object"));
        }
        long len = Types.toUint32(context, ((JSObject)argArray).get(context, "length"));
        Object[] argList = new Object[(int)len];
        int i = 0;
        while ((long)i < len) {
            argList[i] = ((JSObject)argArray).get(context, "" + i);
            ++i;
        }
        return context.call((JSFunction)self, thisArg, argList);
    }
}

