/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.linker.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.qmx.jitescript.CodeBlock;
import me.qmx.jitescript.JDKVersion;
import me.qmx.jitescript.JiteClass;
import me.qmx.jitescript.util.CodegenUtils;
import org.dynjs.runtime.DynObject;
import org.dynjs.runtime.DynamicClassLoader;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.linker.java.ObjectMethodGenerator;
import org.dynjs.runtime.linker.js.ShadowObjectLinkStrategy;

public class JSJavaImplementationManager {
    private static AtomicInteger counter = new AtomicInteger();
    private Map<Class<?>, Class<?>> implementations = new HashMap();
    private ObjectMethodGenerator objectMethodGenerator = new ObjectMethodGenerator();
    private ShadowObjectLinkStrategy shadowLinker;

    public JSJavaImplementationManager(ShadowObjectLinkStrategy shadowLinker) {
        this.shadowLinker = shadowLinker;
    }

    public Object getImplementationWrapper(Class<?> targetClass, ExecutionContext context, JSObject implementation) throws Exception {
        Class<?> implClass = this.getImplementationWrapper(targetClass, context.getClassLoader());
        Constructor<?> ctor = implClass.getConstructor(ExecutionContext.class, JSObject.class);
        JSObject shadow = this.createShadow(context, implClass, implementation);
        Object implInstance = ctor.newInstance(context, implementation);
        if (shadow != null) {
            this.shadowLinker.putShadowObject(implInstance, shadow);
        }
        return implInstance;
    }

    protected JSObject createShadow(ExecutionContext context, Class<?> implClass, JSObject implementation) {
        DynObject shadow = new DynObject(context.getGlobalObject());
        Method[] methods = implClass.getDeclaredMethods();
        boolean shadowed = false;
        List<String> propNames = implementation.getOwnPropertyNames().toList();
        block0: for (String propName : propNames) {
            for (Method m : methods) {
                if (m.getName().equals(propName)) continue block0;
            }
            Object val = implementation.get(context, propName);
            if (!(val instanceof JSFunction)) continue;
            shadowed = true;
            shadow.put(propName, val);
            implementation.delete(context, propName, false);
        }
        if (shadowed) {
            return shadow;
        }
        return null;
    }

    public Class<?> getImplementationWrapper(Class<?> targetClass, DynamicClassLoader classLoader) {
        Class<?> implClass = this.implementations.get(targetClass);
        if (implClass == null) {
            implClass = this.createImplementationWrapper(targetClass, classLoader);
            this.implementations.put(targetClass, implClass);
        }
        return implClass;
    }

    private Class<?> createImplementationWrapper(Class<?> targetClass, DynamicClassLoader classLoader) {
        String className = "org/dynjs/gen/impl/" + targetClass.getSimpleName() + "JS_" + counter.getAndIncrement();
        Class superClass = targetClass.isInterface() ? Object.class : targetClass;
        String superClassName = CodegenUtils.p(superClass);
        String[] interfaces = null;
        interfaces = targetClass.isInterface() ? new String[]{CodegenUtils.p(targetClass)} : new String[]{};
        JiteClass jiteClass = new JiteClass(className, superClassName, interfaces);
        jiteClass.defineField("context", 2, CodegenUtils.ci(ExecutionContext.class), null);
        jiteClass.defineField("implementation", 2, CodegenUtils.ci(JSObject.class), null);
        CodeBlock codeBlock = new CodeBlock().aload(0).invokespecial(superClassName, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0])).aload(0).aload(1).putfield(className.replace('.', '/'), "context", CodegenUtils.ci(ExecutionContext.class)).aload(0).aload(2).putfield(className.replace('.', '/'), "implementation", CodegenUtils.ci(JSObject.class)).aload(2).voidreturn();
        jiteClass.defineMethod("<init>", 1, CodegenUtils.sig(Void.TYPE, ExecutionContext.class, JSObject.class), codeBlock);
        this.defineMethods(targetClass, jiteClass, superClass);
        byte[] bytecode = jiteClass.toBytes(JDKVersion.V1_7);
        return classLoader.define(jiteClass.getClassName().replace('/', '.'), bytecode);
    }

    private void defineMethods(Class<?> targetClass, JiteClass jiteClass, Class<?> superClass) {
        for (Method method : this.getMethods(targetClass)) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
            this.defineMethod(method, jiteClass, superClass);
        }
    }

    private void defineMethod(Method method, JiteClass jiteClass, Class<?> superClass) {
        this.objectMethodGenerator.defineMethod(method, jiteClass, superClass);
    }

    private List<Method> getMethods(Class<?> targetClass) {
        LinkedList<Method> methods = new LinkedList<Method>();
        methods.addAll(Arrays.asList(targetClass.getMethods()));
        return this.addProtectedMethods(targetClass, methods);
    }

    private List<Method> addProtectedMethods(Class<?> targetClass, List<Method> methods) {
        if (targetClass != null && !targetClass.equals(Object.class)) {
            List<Method> declaredMethods = Collections.unmodifiableList(methods);
            for (Method method : targetClass.getDeclaredMethods()) {
                if (!Modifier.isProtected(method.getModifiers()) || this.alreadyDeclaredMethod(method, declaredMethods)) continue;
                methods.add(method);
            }
            this.addProtectedMethods(targetClass.getSuperclass(), methods);
        }
        return methods;
    }

    private boolean alreadyDeclaredMethod(Method method, List<Method> declaredMethods) {
        Object[] parameterTypes = method.getParameterTypes();
        for (Method declaredMethod : declaredMethods) {
            if (!method.getName().equals(declaredMethod.getName()) || !Arrays.equals(parameterTypes, declaredMethod.getParameterTypes())) continue;
            return true;
        }
        return false;
    }
}

