/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.modules;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.dynjs.runtime.DynJS;
import org.dynjs.runtime.DynamicClassLoader;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.modules.ModuleProvider;

public class ClasspathModuleProvider
extends ModuleProvider {
    @Override
    public boolean load(DynJS runtime, ExecutionContext context, String moduleId) {
        DynamicClassLoader classLoader = context.getClassLoader();
        try {
            InputStream is = classLoader.getResourceAsStream(moduleId);
            if (is == null) {
                return false;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            context.getGlobalObject().getRuntime().newRunner().withFileName(moduleId).withContext(context).withSource(reader).execute();
            try {
                is.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("There was an error loading the module " + moduleId + ". Error message: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String generateModuleID(ExecutionContext context, String moduleName) {
        String name;
        DynamicClassLoader classLoader = context.getClassLoader();
        URL moduleURL = classLoader.getResource(name = this.normalizeName(moduleName));
        if (moduleURL != null) {
            return name;
        }
        moduleURL = classLoader.getResource(moduleName + "/index.js");
        if (moduleURL != null) {
            return moduleName + "/index.js";
        }
        return null;
    }
}

