/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.modules;

import java.util.Arrays;
import java.util.Date;
import org.dynjs.runtime.DynArray;
import org.dynjs.runtime.DynObject;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.builtins.types.date.DynDate;
import org.dynjs.runtime.builtins.types.regexp.DynRegExp;
import org.dynjs.runtime.modules.Export;
import org.dynjs.runtime.modules.Module;

@Module(name="dyn_util")
public class UtilModule {
    @Export
    public String format(Object ... args) {
        if (args[0] instanceof String) {
            String format = (String)args[0];
            return String.format(format, Arrays.copyOfRange(args, 1, args.length));
        }
        String concat = "";
        for (Object arg : args) {
            concat = concat + arg.toString() + " ";
        }
        return concat.trim();
    }

    @Export
    public void debug(String message) {
        System.err.println(message);
    }

    @Export
    public void error(Object ... args) {
        for (Object arg : args) {
            this.debug(arg.toString());
        }
    }

    @Export
    public void puts(Object ... args) {
        for (Object arg : args) {
            System.out.println(arg.toString());
        }
    }

    @Export
    public void print(Object ... args) {
        for (Object arg : args) {
            System.out.print(arg.toString());
        }
    }

    @Export
    public void log(String message) {
        System.out.println(new Date().toString() + " - " + message);
    }

    @Export
    public boolean isArray(Object thing) {
        return thing instanceof DynArray;
    }

    @Export
    public boolean isRegExp(Object thing) {
        return thing instanceof DynRegExp;
    }

    @Export
    public boolean isDate(Object thing) {
        return thing instanceof DynDate;
    }

    @Export
    public boolean isError(Object thing) {
        return thing instanceof DynObject && ((JSObject)thing).getClassName().equals("Error");
    }
}

